/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.informix.administration.instructions;

import com.ibm.arcs.basic.unit.ByteUnit;
import com.ibm.arcs.basic.unit.ByteValue;
import com.ibm.informix.administration.AbstractSQLAdministrationInstruction;
import com.ibm.informix.administration.SQLAdministrationParameters;

public class SqlTracingStartInstruction
extends AbstractSQLAdministrationInstruction {
    private final Integer numberOfTraces;
    private final ByteValue traceSize;
    private final Level level;
    private final Mode mode;

    public SqlTracingStartInstruction(Integer n, ByteValue byteValue) {
        super(SqlTracingStartInstruction.buildExecuteParameters(n, byteValue, null, null));
        this.numberOfTraces = n;
        this.traceSize = byteValue;
        this.level = null;
        this.mode = null;
    }

    public SqlTracingStartInstruction(Integer n, ByteValue byteValue, Level level, Mode mode) {
        super(SqlTracingStartInstruction.buildExecuteParameters(n, byteValue, null, null));
        this.numberOfTraces = n;
        this.traceSize = byteValue;
        this.level = level;
        this.mode = mode;
    }

    public Integer getNumberOfTraces() {
        return this.numberOfTraces;
    }

    public ByteValue getTraceSize() {
        return this.traceSize;
    }

    public Level getLevel() {
        return this.level;
    }

    public Mode getMode() {
        return this.mode;
    }

    private static SQLAdministrationParameters buildExecuteParameters(Integer n, ByteValue byteValue, Level level, Mode mode) {
        SQLAdministrationParameters sQLAdministrationParameters = new SQLAdministrationParameters();
        sQLAdministrationParameters.addParameters("set sql tracing on");
        if (n != null) {
            sQLAdministrationParameters.addParameter(n.toString());
            if (byteValue != null) {
                sQLAdministrationParameters.addParameter(byteValue.toString(ByteUnit.KIBIBYTE));
                if (level != null) {
                    sQLAdministrationParameters.addParameter(level.name());
                    if (mode != null) {
                        sQLAdministrationParameters.addParameter(mode.name());
                    }
                }
            }
        }
        return sQLAdministrationParameters;
    }

    public static enum Level {
        low,
        med,
        high;

    }

    public static enum Mode {
        global,
        user;

    }
}

