/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.informix.bundle.ui;

import com.ibm.arcs.basic.unit.ByteUnit;
import com.ibm.arcs.basic.unit.ByteValue;
import com.ibm.informix.bundle.BundleMember;
import com.ibm.informix.bundle.FeatureMember;
import com.ibm.informix.bundle.ui.BundleTree;
import com.ibm.informix.bundle.ui.BundleTreeColumn;
import com.ibm.informix.bundle.ui.BundleTreeListener;
import java.math.RoundingMode;
import java.text.NumberFormat;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.TreeItem;

public class SizeColumn
extends BundleTreeColumn
implements BundleTreeListener {
    public static final ByteUnit FEATUREMEMBER_BYTEUNIT = ByteUnit.KIBIBYTE;
    public static final ByteUnit GROUP_BYTEUNIT = ByteUnit.MEBIBYTE;
    public static final NumberFormat FEATUREMEMBER_FORMAT;
    public static final NumberFormat GROUP_FORMAT;
    public static final String SIZE = "SIZE_INDEX";
    public static final String TOTAL = "TOTAL_INDEX";
    public static final ByteValue ZERO;
    private static final String ZERO_GROUP;

    static {
        ZERO = new ByteValue(0L, GROUP_BYTEUNIT);
        FEATUREMEMBER_FORMAT = NumberFormat.getIntegerInstance();
        FEATUREMEMBER_FORMAT.setRoundingMode(RoundingMode.CEILING);
        GROUP_FORMAT = NumberFormat.getNumberInstance();
        ZERO_GROUP = SizeColumn.getSize(ZERO, GROUP_FORMAT, GROUP_BYTEUNIT);
        GROUP_FORMAT.setMinimumFractionDigits(2);
        GROUP_FORMAT.setMaximumFractionDigits(2);
        GROUP_FORMAT.setRoundingMode(RoundingMode.CEILING);
    }

    public SizeColumn(BundleTree bundleTree) {
        super(bundleTree, "Size");
        bundleTree.addListener(this);
    }

    @Override
    public void onCreate(TreeItem treeItem) {
        BundleMember bundleMember = (BundleMember)treeItem.getData();
        if (bundleMember instanceof FeatureMember) {
            ByteValue byteValue = new ByteValue(((FeatureMember)bundleMember).getFile().length(), ByteUnit.BYTE);
            treeItem.setText(this.getIndex(), SizeColumn.getSize(byteValue, FEATUREMEMBER_FORMAT, FEATUREMEMBER_BYTEUNIT));
            this.onCreate(treeItem, byteValue);
        } else {
            treeItem.setData(TOTAL, (Object)ZERO);
            treeItem.setData(SIZE, (Object)ZERO);
            treeItem.setText(this.getIndex(), ZERO_GROUP);
        }
    }

    private void onCreate(TreeItem treeItem, ByteValue byteValue) {
        TreeItem treeItem2 = treeItem.getParentItem();
        if (treeItem2 != null) {
            treeItem2.setData(TOTAL, (Object)((ByteValue)treeItem2.getData(TOTAL)).add(byteValue));
            if (treeItem.getChecked()) {
                treeItem2.setData(SIZE, (Object)((ByteValue)treeItem2.getData(SIZE)).add(byteValue));
                treeItem2.setText(this.getIndex(), SizeColumn.getSize(byteValue, GROUP_FORMAT, GROUP_BYTEUNIT));
            }
            this.onCreate(treeItem2, byteValue);
        }
    }

    @Override
    public int getWidth() {
        return 120;
    }

    @Override
    public int getStyle() {
        return 131072;
    }

    @Override
    public void itemSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.detail == 32) {
            TreeItem treeItem = (TreeItem)selectionEvent.item;
            this.ascend(treeItem.getParentItem(), this.descend(treeItem, treeItem.getChecked()), treeItem.getChecked());
        }
    }

    private void ascend(TreeItem treeItem, ByteValue byteValue, boolean bl) {
        if (treeItem != null) {
            ByteValue byteValue2 = (ByteValue)treeItem.getData(SIZE);
            ByteValue byteValue3 = bl ? byteValue2.add(byteValue) : byteValue2.subtract(byteValue);
            treeItem.setData(SIZE, (Object)byteValue3);
            treeItem.setText(this.getIndex(), SizeColumn.getSize(byteValue3, GROUP_FORMAT, GROUP_BYTEUNIT));
            this.ascend(treeItem.getParentItem(), byteValue, bl);
        }
    }

    private ByteValue descend(TreeItem treeItem, boolean bl) {
        ByteValue byteValue;
        if (treeItem.getItemCount() > 0) {
            if (bl) {
                byteValue = (ByteValue)treeItem.getData(TOTAL);
                treeItem.setData(SIZE, (Object)byteValue);
                treeItem.setText(this.getIndex(), SizeColumn.getSize(byteValue, GROUP_FORMAT, GROUP_BYTEUNIT));
            } else {
                byteValue = (ByteValue)treeItem.getData(SIZE);
                treeItem.setData(SIZE, (Object)ZERO);
                treeItem.setText(this.getIndex(), ZERO_GROUP);
            }
            TreeItem[] treeItemArray = treeItem.getItems();
            int n = treeItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem treeItem2 = treeItemArray[n2];
                this.descend(treeItem2, bl);
                ++n2;
            }
        } else {
            BundleMember bundleMember = (BundleMember)treeItem.getData();
            byteValue = bundleMember instanceof FeatureMember ? new ByteValue(((FeatureMember)bundleMember).getFile().length(), ByteUnit.BYTE) : (ByteValue)treeItem.getData(TOTAL);
        }
        return byteValue;
    }

    public static String getSize(ByteValue byteValue, NumberFormat numberFormat, ByteUnit byteUnit) {
        return String.valueOf(numberFormat.format(byteValue.convertTo(byteUnit).getValue())) + ' ' + byteUnit.getAbbreviation();
    }

    public ByteValue getTotal() {
        ByteValue byteValue = ZERO;
        TreeItem[] treeItemArray = this.getBundleTree().getTree().getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem = treeItemArray[n2];
            byteValue = byteValue.add((ByteValue)treeItem.getData(SIZE));
            ++n2;
        }
        return byteValue;
    }
}

