/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.informix.bundle;

import com.ibm.arcs.basic.strings.IStringMatcher;
import com.ibm.arcs.host.KernelType;
import com.ibm.informix.bundle.BundleMember;
import com.ibm.informix.bundle.Extension;
import com.ibm.informix.bundle.FeatureMember;
import com.ibm.informix.bundle.Package;
import com.ibm.informix.configuration.Platform;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class Bundle {
    static final String TAG = "Bundle";
    static final String NAME_TAG = "BundleName";
    static final String VERSION_TAG = "BundleVersion";
    private final Map<String, FeatureMember> fileToFeatureMap;
    private final Map<String, BundleMember> bundleMembers;
    final Platform platform;
    private String bundleName;
    private String bundleVersion;
    private final Map<String, Package> packageMap;
    private final Extension extension;

    Bundle(Platform platform, String string, String string2) {
        this.platform = platform;
        this.bundleName = string;
        this.bundleVersion = string2;
        this.packageMap = new HashMap<String, Package>();
        this.fileToFeatureMap = new HashMap<String, FeatureMember>();
        this.bundleMembers = new HashMap<String, BundleMember>();
        this.extension = new Extension(this);
    }

    public String getBundleName() {
        return this.bundleName;
    }

    void setBundleName(String string) {
        this.bundleName = string;
    }

    public String getBundleVersion() {
        return this.bundleVersion;
    }

    void setBundleVersion(String string) {
        this.bundleVersion = string;
    }

    public Package putPackage(Package package_) {
        this.putMember(package_);
        return this.packageMap.put(package_.getId(), package_);
    }

    public Package getPackage(String string) {
        return this.packageMap.get(string);
    }

    public Collection<Package> getPackages() {
        return this.packageMap.values();
    }

    public Package removePackage(Package package_) {
        this.removeMember(package_.getId());
        return this.packageMap.remove(package_.getId());
    }

    public BundleMember getMember(String string) {
        return this.bundleMembers.get(string);
    }

    BundleMember putMember(BundleMember bundleMember) {
        return this.bundleMembers.put(bundleMember.getId(), bundleMember);
    }

    BundleMember removeMember(String string) {
        return this.bundleMembers.remove(string);
    }

    Extension getExtension() {
        return this.extension;
    }

    static IStringMatcher getMatcher(final String string) {
        return new IStringMatcher(){

            public boolean matches(String string2) {
                return string2.equals(string);
            }
        };
    }

    FeatureMember registerFeatureMember(FeatureMember featureMember) {
        if (this.platform.getKernelType() == KernelType.Windows) {
            return this.fileToFeatureMap.put(featureMember.getName().toLowerCase(), featureMember);
        }
        return this.fileToFeatureMap.put(featureMember.getName(), featureMember);
    }

    FeatureMember getFeatureMember(String string) {
        if (this.platform.getKernelType() == KernelType.Windows) {
            string = string.toLowerCase();
        }
        return this.fileToFeatureMap.get(string);
    }

    int getFeatureMemberCount() {
        return this.fileToFeatureMap.size();
    }

    public Collection<FeatureMember> getFeatureMembers() {
        return this.fileToFeatureMap.values();
    }
}

