/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.informix.bundle;

import com.ibm.arcs.basic.parameter.hierarchical.HierarchicalParameter;
import com.ibm.arcs.basic.parameter.hierarchical.HierarchicalParameterXmlConverter;
import com.ibm.informix.bundle.Bundle;
import com.ibm.informix.bundle.Feature;
import com.ibm.informix.bundle.FeatureGroup;
import com.ibm.informix.bundle.IBundleContainer;
import com.ibm.informix.bundle.Package;
import com.ibm.informix.bundle.Utility;
import java.util.List;

public class BundleExtension {
    private static final String PACKAGE_ID_TAG = "PackageId";
    private static final String PACKAGE_REPLACES_TAG = "PackageReplaces";
    private static final String FEATURE_ID_TAG = "FeatureId";
    private static final String FEATURE_PATTERN_TAG = "FeaturePattern";

    private BundleExtension() {
    }

    static void process(Bundle bundle) throws Exception {
        HierarchicalParameter hierarchicalParameter = HierarchicalParameterXmlConverter.getSharedInstance().read(Utility.getMasterDocExtStream());
        List<HierarchicalParameter> list = Utility.getAllMatching(hierarchicalParameter, "Package");
        for (HierarchicalParameter hierarchicalParameter2 : list) {
            BundleExtension.convert(hierarchicalParameter2, bundle);
        }
    }

    private static void convert(HierarchicalParameter hierarchicalParameter, Bundle bundle) throws Exception {
        String string = Utility.getFirstMatching(hierarchicalParameter, PACKAGE_ID_TAG).getValue();
        String string2 = null;
        try {
            string2 = Utility.getFirstMatching(hierarchicalParameter, PACKAGE_REPLACES_TAG).getValue();
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        Package package_ = (Package)bundle.getMember(string);
        if (package_ == null) {
            if (string2 != null) {
                package_ = (Package)bundle.getMember(string2);
            }
            if (package_ == null) {
                package_ = new Package(bundle, string);
            } else {
                bundle.removePackage(package_);
                package_.packageId = string;
                bundle.putPackage(package_);
            }
        }
        for (HierarchicalParameter hierarchicalParameter2 : Utility.getAllMatching(hierarchicalParameter, "Feature")) {
            BundleExtension.convertFeature(hierarchicalParameter2, package_);
        }
        for (HierarchicalParameter hierarchicalParameter2 : Utility.getAllMatching(hierarchicalParameter, "FeatureGroup")) {
            BundleExtension.convert(hierarchicalParameter2, package_);
        }
    }

    private static FeatureGroup convert(HierarchicalParameter hierarchicalParameter, IBundleContainer iBundleContainer) throws Exception {
        String string = Utility.getFirstMatching(hierarchicalParameter, FEATURE_ID_TAG).getValue();
        FeatureGroup featureGroup = (FeatureGroup)iBundleContainer.getBundle().getMember(string);
        if (featureGroup == null) {
            featureGroup = new FeatureGroup(iBundleContainer, string);
        }
        List<HierarchicalParameter> list = Utility.getAllMatching(hierarchicalParameter, "Feature");
        for (HierarchicalParameter hierarchicalParameter2 : list) {
            BundleExtension.convertFeature(hierarchicalParameter2, featureGroup);
        }
        return featureGroup;
    }

    private static void convertFeature(HierarchicalParameter hierarchicalParameter, IBundleContainer iBundleContainer) throws Exception {
        String string;
        String string2 = Utility.getFirstMatching(hierarchicalParameter, FEATURE_ID_TAG).getValue();
        Feature feature = (Feature)iBundleContainer.getBundle().getMember(string2);
        if (feature == null) {
            feature = new Feature(iBundleContainer, string2);
        } else if (iBundleContainer instanceof FeatureGroup) {
            feature.getParent().remove(feature);
            iBundleContainer.put(feature);
        }
        try {
            for (HierarchicalParameter hierarchicalParameter2 : Utility.getAllMatching(hierarchicalParameter, FEATURE_PATTERN_TAG)) {
                string = hierarchicalParameter2.getValue();
                iBundleContainer.getBundle().getExtension().put(string, feature);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            for (HierarchicalParameter hierarchicalParameter2 : Utility.getAllMatching(hierarchicalParameter, "FeatureDependsOn")) {
                string = hierarchicalParameter2.getValue();
                String[] stringArray = string.split("\\s+");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String string3 = stringArray[n2];
                    feature.addDependency(string3);
                    ++n2;
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }
}

