/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.informix.bundle;

import com.ibm.informix.configuration.InformixInstance;
import java.io.File;
import java.util.ArrayList;

public class BundleReader {
    private final String informixDir;
    private final ArrayList<BundleReaderListener> bundleReaderListeners;

    public BundleReader(InformixInstance informixInstance) {
        String string = informixInstance.getInformixDir();
        if (!string.endsWith(File.separator)) {
            string = String.valueOf(string) + File.separator;
        }
        this.informixDir = string;
        this.bundleReaderListeners = new ArrayList(1);
    }

    public boolean registerListener(BundleReaderListener bundleReaderListener) {
        return this.bundleReaderListeners.add(bundleReaderListener);
    }

    public void readBundle() {
        this.readFiles(new File(this.informixDir));
    }

    private void readFiles(File file) {
        File[] fileArray = file.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file2 = fileArray[n2];
            String string = file2.getAbsolutePath().substring(this.informixDir.length());
            for (BundleReaderListener bundleReaderListener : this.bundleReaderListeners) {
                if (!file2.canRead()) continue;
                bundleReaderListener.process(file2, string);
            }
            if (file2.isDirectory() && file2.canRead()) {
                this.readFiles(file2);
            }
            ++n2;
        }
    }

    public static interface BundleReaderListener {
        public void process(File var1, String var2);
    }
}

