/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.informix.bundle;

import com.ibm.informix.bundle.Bundle;
import com.ibm.informix.bundle.Feature;
import com.ibm.informix.bundle.FeatureMember;
import com.ibm.informix.bundle.Package;
import com.ibm.informix.bundle.message.Messages;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;

public class Extension {
    private final Package unknownPackage;
    private final Feature unknownFeature;
    private final Feature devNull;
    private final Map<String, Feature> extensions;

    Extension(Bundle bundle) {
        this.unknownPackage = new Package(bundle, Messages.InstalledBundle_Miscellaneous);
        this.unknownFeature = new Feature(this.unknownPackage, Messages.InstalledBundle_Miscellaneous);
        this.devNull = new Feature(this.unknownPackage, Messages.InstalledBundle_Miscellaneous);
        this.extensions = new TreeMap<String, Feature>(new Comparator<String>(){

            @Override
            public int compare(String string, String string2) {
                return string2.toLowerCase().compareTo(string.toLowerCase());
            }
        });
        this.init();
    }

    private void init() {
        this.exclude("tmp/.*");
        this.exclude("etc/\\.conf\\..*");
        this.exclude("etc/\\.infos\\..*");
        this.exclude("bin/configuration/org\\.eclipse.*");
    }

    Feature put(String string, Feature feature) {
        return this.extensions.put(string, feature);
    }

    FeatureMember put(String string, FeatureMember.Type type) {
        Feature feature = this.getFeature(string);
        if (feature == null) {
            feature = this.unknownFeature;
        } else if (feature.equals(this.devNull)) {
            return null;
        }
        return new FeatureMember(string, type, null, feature);
    }

    void exclude(String string) {
        this.extensions.put(string, this.devNull);
    }

    private Feature getFeature(String string) {
        for (String string2 : this.extensions.keySet()) {
            if (!Pattern.matches(string2, string)) continue;
            return this.extensions.get(string2);
        }
        return null;
    }
}

