/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.informix.bundle;

import com.ibm.arcs.basic.parameter.hierarchical.HierarchicalParameter;
import com.ibm.informix.bundle.Bundle;
import com.ibm.informix.bundle.BundleMember;
import com.ibm.informix.bundle.FeatureMember;
import com.ibm.informix.bundle.IBundleContainer;
import com.ibm.informix.bundle.Utility;
import com.ibm.informix.bundle.message.BundleMessages;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class Feature
implements BundleMember {
    static final String TAG = "Feature";
    static final String FEATURE_ID_TAG = "FeatureName";
    static final String FEATURE_DEPENDS_ON_TAG = "FeatureDependsOn";
    static final String FEATURE_OPTIONAL_DEPENDENCY_TAG = "OptionalDependency";
    private final String featureId;
    IBundleContainer parent;
    private final Map<String, FeatureMember> featureMembers;
    private final Set<String> dependencies;

    Feature(IBundleContainer iBundleContainer, String string) {
        this.featureId = string;
        this.parent = iBundleContainer;
        this.dependencies = new TreeSet<String>();
        this.featureMembers = new TreeMap<String, FeatureMember>(new Comparator<String>(){

            @Override
            public int compare(String string, String string2) {
                return string.toLowerCase().compareTo(string2.toLowerCase());
            }
        });
        iBundleContainer.put(this);
    }

    @Override
    public String getId() {
        return this.featureId;
    }

    @Override
    public String getName() {
        return Feature.getName(this.featureId);
    }

    public static String getName(String string) {
        return BundleMessages.getName(string);
    }

    @Override
    public String getDescription() {
        return BundleMessages.getDescription(this.featureId);
    }

    @Override
    public IBundleContainer getParent() {
        return this.parent;
    }

    @Override
    public Bundle getBundle() {
        return this.parent.getBundle();
    }

    public FeatureMember putFeatureMember(FeatureMember featureMember) {
        FeatureMember featureMember2 = this.featureMembers.put(featureMember.getId(), featureMember);
        if (featureMember2 == null) {
            this.parent.getBundle().registerFeatureMember(featureMember);
        }
        return featureMember2;
    }

    public FeatureMember remove(FeatureMember featureMember) {
        return this.featureMembers.remove(featureMember.getId());
    }

    public Collection<FeatureMember> getFeatureMembers() {
        return Collections.unmodifiableCollection(this.featureMembers.values());
    }

    public FeatureMember getFeatureMember(String string) {
        return this.featureMembers.get(string);
    }

    public void addDependency(String string) {
        this.dependencies.add(string);
    }

    public Set<String> getDependencies() {
        return Collections.unmodifiableSet(this.dependencies);
    }

    public boolean dependsOn(Feature feature) {
        return this.dependencies.contains(feature.getId());
    }

    static Feature convert(HierarchicalParameter hierarchicalParameter, IBundleContainer iBundleContainer) throws Exception {
        String string = Utility.getFirstMatching(hierarchicalParameter, FEATURE_ID_TAG).getValue();
        Feature feature = (Feature)iBundleContainer.getBundle().getMember(string);
        if (feature == null) {
            feature = new Feature(iBundleContainer, string);
        }
        List<HierarchicalParameter> list = Utility.getAllMatching(hierarchicalParameter, "FeatureMember");
        for (HierarchicalParameter hierarchicalParameter2 : list) {
            FeatureMember.convert(hierarchicalParameter2, feature);
        }
        return feature;
    }
}

