/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.informix.bundle;

import com.ibm.arcs.basic.parameter.hierarchical.HierarchicalParameter;
import com.ibm.arcs.host.KernelType;
import com.ibm.informix.bundle.Bundle;
import com.ibm.informix.bundle.BundleMember;
import com.ibm.informix.bundle.Feature;
import com.ibm.informix.bundle.SpecificTargetName;
import com.ibm.informix.bundle.Utility;
import com.ibm.informix.configuration.Platform;
import com.ibm.informix.configuration.PlatformNameType;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class FeatureMember
implements BundleMember {
    static final String TAG = "FeatureMember";
    private static final String ID_TAG = "id";
    private static final String TYPE_TAG = "Type";
    private final String id;
    private final Type type;
    private final SpecificTargetName specificTargetName;
    private final List<Feature> parents;
    private String name;
    private File file;

    FeatureMember(String string, Type type, SpecificTargetName specificTargetName, Feature feature) {
        this.id = string;
        this.type = type;
        this.specificTargetName = specificTargetName;
        this.parents = new ArrayList<Feature>(1);
        this.addParent(feature);
    }

    void addParent(Feature feature) {
        this.parents.add(feature);
        feature.putFeatureMember(this);
    }

    @Override
    public String getName() {
        if (this.name == null) {
            if (this.specificTargetName != null) {
                Platform platform = this.getBundle().platform;
                PlatformNameType[] platformNameTypeArray = this.specificTargetName.getPlatforms();
                int n = platformNameTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    PlatformNameType platformNameType = platformNameTypeArray[n2];
                    if (platformNameType.matches(platform.getKernelType(), platform.getPlatformBits(), platform.getIsaType())) {
                        this.name = this.specificTargetName.getName();
                        break;
                    }
                    ++n2;
                }
            }
            if (this.name == null) {
                this.name = String.valueOf(this.id) + this.getExtension();
            }
        }
        return this.name;
    }

    @Override
    public String getDescription() {
        if (this.file != null) {
            try {
                return this.file.getCanonicalPath();
            }
            catch (IOException iOException) {}
        }
        return this.id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public BundleMember getParent() {
        return this.parents.get(0);
    }

    @Override
    public Bundle getBundle() {
        return this.parents.get(0).getBundle();
    }

    public List<Feature> getParents() {
        return Collections.unmodifiableList(this.parents);
    }

    public SpecificTargetName getSpecificTargetName() {
        return this.specificTargetName;
    }

    public File getFile() {
        return this.file;
    }

    void setFile(File file) {
        this.file = file;
    }

    private String getExtension() {
        switch (this.type) {
            case StaticLib: {
                return this.getStaticLibExtension();
            }
            case SharedLib: {
                return this.getSharedLibExtension();
            }
            case Executable: {
                return this.getExecutableExtension();
            }
            case CommandScript: {
                return this.getCommandScriptExtension();
            }
        }
        return "";
    }

    private String getStaticLibExtension() {
        return this.getBundle().platform.getKernelType() == KernelType.Windows ? ".lib" : ".a";
    }

    private String getSharedLibExtension() {
        switch (PlatformNameType.getPlatformNameType((Platform)this.getBundle().platform)) {
            case nt_intel: 
            case win64_amd: {
                return ".dll";
            }
            case macosx32: 
            case macosx64: {
                return ".dylib";
            }
            case hp11: 
            case hp64: {
                return ".sl";
            }
        }
        return ".so";
    }

    private String getExecutableExtension() {
        return this.getBundle().platform.getKernelType() == KernelType.Windows ? ".exe" : "";
    }

    private String getCommandScriptExtension() {
        return this.getBundle().platform.getKernelType() == KernelType.Windows ? ".bat" : ".sh";
    }

    static FeatureMember convert(HierarchicalParameter hierarchicalParameter, Feature feature) throws Exception {
        String string = hierarchicalParameter.getAttribute(ID_TAG).getValue();
        Type type = Type.valueOf(Utility.getFirstMatching(hierarchicalParameter, TYPE_TAG).getValue());
        HierarchicalParameter hierarchicalParameter2 = null;
        try {
            hierarchicalParameter2 = Utility.getFirstMatching(hierarchicalParameter, "SpecificTargetName");
        }
        catch (Exception exception) {}
        SpecificTargetName specificTargetName = hierarchicalParameter2 == null ? null : SpecificTargetName.convert(hierarchicalParameter2);
        String string2 = specificTargetName == null ? string : specificTargetName.getName();
        FeatureMember featureMember = feature.getParent().getBundle().getFeatureMember(string2);
        if (featureMember != null) {
            featureMember.addParent(feature);
            return featureMember;
        }
        return new FeatureMember(string, type, specificTargetName, feature);
    }

    public static enum Type {
        Archive,
        CommandScript,
        Directory,
        Executable,
        File,
        Jarfile,
        Link,
        SharedLib,
        SharedLibLink,
        SharedLibSoftLink,
        SoftLink,
        StaticLib,
        InstallOverhead;

    }
}

