/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.informix.bundle;

import com.ibm.arcs.basic.parameter.hierarchical.HierarchicalParameter;
import com.ibm.arcs.basic.parameter.hierarchical.HierarchicalParameterXmlConverter;
import com.ibm.informix.bundle.Utility;
import com.ibm.informix.bundle.message.BundleMessages;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class InstallType {
    private static final String TAG = "Type";
    private static final String TYPEID = "TypeId";
    private static final String PACKAGE = "Package";
    private static final String FEATURE = "Feature";
    private static final String FEATUREMEMBER = "FeatureMember";
    private final String name;
    private final Set<String> bundleMembers;

    public InstallType(String string) {
        this.name = string;
        this.bundleMembers = new HashSet<String>();
    }

    public String getName() {
        return this.name;
    }

    public boolean add(String string) {
        return this.bundleMembers.add(string);
    }

    public Set<String> getBundleMembers() {
        return Collections.unmodifiableSet(this.bundleMembers);
    }

    public static Set<InstallType> getInstallTypes() throws Exception {
        InputStream inputStream = Utility.getInstallTypeStream();
        HierarchicalParameter hierarchicalParameter = HierarchicalParameterXmlConverter.getSharedInstance().read(inputStream);
        HashSet<InstallType> hashSet = new HashSet<InstallType>();
        List<HierarchicalParameter> list = Utility.getAllMatching(hierarchicalParameter, TAG);
        for (HierarchicalParameter hierarchicalParameter2 : list) {
            String string = BundleMessages.getName(Utility.getFirstMatching(hierarchicalParameter2, TYPEID).getValue());
            InstallType installType = new InstallType(string);
            try {
                InstallType.findAddMembers(installType, hierarchicalParameter2, PACKAGE);
                InstallType.findAddMembers(installType, hierarchicalParameter2, FEATURE);
                InstallType.findAddMembers(installType, hierarchicalParameter2, FEATUREMEMBER);
            }
            catch (Exception exception) {}
            hashSet.add(installType);
        }
        return hashSet;
    }

    private static void findAddMembers(InstallType installType, HierarchicalParameter hierarchicalParameter, String string) {
        List<HierarchicalParameter> list = Utility.getAllMatching(hierarchicalParameter, string);
        for (HierarchicalParameter hierarchicalParameter2 : list) {
            InstallType.addBundleMembers(installType, hierarchicalParameter2.getValue().split("\\s+"));
        }
    }

    private static void addBundleMembers(InstallType installType, String[] stringArray) {
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray2[n2];
            installType.add(string);
            ++n2;
        }
    }
}

