/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.informix.bundle;

import com.ibm.arcs.host.KernelType;
import com.ibm.informix.bundle.Bundle;
import com.ibm.informix.bundle.BundleMember;
import com.ibm.informix.bundle.BundleReader;
import com.ibm.informix.bundle.Feature;
import com.ibm.informix.bundle.FeatureGroup;
import com.ibm.informix.bundle.FeatureMember;
import com.ibm.informix.bundle.IBundleContainer;
import com.ibm.informix.bundle.MasterBundle;
import com.ibm.informix.bundle.Package;
import com.ibm.informix.bundle.Utility;
import com.ibm.informix.bundle.message.Messages;
import com.ibm.informix.configuration.InformixInstance;
import com.ibm.informix.configuration.space.InformixChunk;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class InstalledBundle
extends Bundle {
    final MasterBundle masterBundle;
    private final InformixInstance informixInstance;

    public InstalledBundle(InformixInstance informixInstance) throws Exception {
        super(informixInstance.getServerPlatform(), informixInstance.getDatabaseServerName().getName(), informixInstance.getInformixVersion().getVersionString());
        Object object2;
        this.informixInstance = informixInstance;
        this.masterBundle = new MasterBundle(informixInstance);
        String string = Utility.getPathWithSeparator(informixInstance.getInformixDir());
        if (!new File(string).isDirectory()) {
            throw new IllegalArgumentException(String.valueOf(Messages.InstalledBundle_NotDirectory) + ' ' + string);
        }
        for (Object object2 : informixInstance.getInformixDataSpaces()) {
            for (InformixChunk informixChunk : object2.getChunks()) {
                String string2 = new File(informixChunk.getPath()).getCanonicalPath();
                if (!string2.startsWith(string)) continue;
                int n = string.length();
                if (!string.endsWith(File.separator)) {
                    ++n;
                }
                string2 = string2.substring(n);
                if (this.masterBundle.platform.getKernelType() == KernelType.Windows) {
                    string2 = string2.replace('\\', '/');
                    string2 = string2.toLowerCase();
                }
                this.masterBundle.getExtension().exclude("\\Q" + string2 + "\\E");
            }
        }
        object2 = new BundleReader(informixInstance);
        ((BundleReader)object2).registerListener(new InformixBundleReader(this));
        ((BundleReader)object2).readBundle();
        this.cleanup();
    }

    public InformixInstance getInformixInstance() {
        return this.informixInstance;
    }

    private void cleanup() {
        ArrayList<Package> arrayList = new ArrayList<Package>();
        for (Package package_ : this.getPackages()) {
            boolean bl = false;
            for (Feature feature : package_.getFeatures()) {
                if (feature instanceof FeatureGroup) {
                    bl = true;
                    break;
                }
                if (feature.getFeatureMembers().size() <= 0) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            arrayList.add(package_);
        }
        for (Package package_ : arrayList) {
            this.removePackage(package_);
        }
    }

    class InformixBundleReader
    implements BundleReader.BundleReaderListener {
        private final InstalledBundle installedBundle;

        InformixBundleReader(InstalledBundle installedBundle2) {
            this.installedBundle = installedBundle2;
        }

        @Override
        public void process(File file, String string) {
            FeatureMember featureMember;
            if (file.isDirectory()) {
                return;
            }
            if (InstalledBundle.this.masterBundle.platform.getKernelType() == KernelType.Windows) {
                string = string.replace('\\', '/');
            }
            if ((featureMember = InstalledBundle.this.masterBundle.getFeatureMember(string)) == null && (featureMember = InstalledBundle.this.masterBundle.getExtension().put(string, FeatureMember.Type.File)) == null) {
                return;
            }
            featureMember.setFile(file);
            InstalledBundle.this.registerFeatureMember(featureMember);
            List<Feature> list = featureMember.getParents();
            ArrayList<Feature> arrayList = new ArrayList<Feature>(2);
            for (Feature feature : list) {
                Feature feature2 = (Feature)this.recurse(feature);
                feature2.putFeatureMember(featureMember);
                for (Feature feature3 : arrayList) {
                    if (feature2.dependsOn(feature3)) {
                        feature2.remove(featureMember);
                        continue;
                    }
                    if (!feature3.dependsOn(feature2)) continue;
                    feature3.remove(featureMember);
                }
                arrayList.add(feature2);
            }
        }

        private BundleMember recurse(BundleMember bundleMember) {
            BundleMember bundleMember2 = this.installedBundle.getMember(bundleMember.getId());
            if (bundleMember2 == null) {
                if (bundleMember instanceof FeatureGroup) {
                    return new FeatureGroup((IBundleContainer)this.recurse(bundleMember.getParent()), bundleMember.getId());
                }
                if (bundleMember instanceof Feature) {
                    Feature feature = new Feature((IBundleContainer)this.recurse(bundleMember.getParent()), bundleMember.getId());
                    for (String string : ((Feature)bundleMember).getDependencies()) {
                        feature.addDependency(string);
                    }
                    return feature;
                }
                if (bundleMember instanceof Package) {
                    return new Package(this.installedBundle, bundleMember.getId());
                }
            }
            return bundleMember2;
        }
    }
}

