/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.informix.bundle;

import com.ibm.arcs.basic.parameter.hierarchical.HierarchicalParameter;
import com.ibm.arcs.basic.parameter.hierarchical.HierarchicalParameterXmlConverter;
import com.ibm.informix.bundle.Bundle;
import com.ibm.informix.bundle.BundleExtension;
import com.ibm.informix.bundle.Package;
import com.ibm.informix.bundle.Utility;
import com.ibm.informix.configuration.InformixInstance;
import com.ibm.informix.configuration.Platform;
import java.io.InputStream;
import java.util.List;

public class MasterBundle
extends Bundle {
    public MasterBundle(Platform platform) throws Exception {
        super(platform, "Master Bundle", "");
        this.init(Utility.getMasterDocStream());
    }

    public MasterBundle(InformixInstance informixInstance) throws Exception {
        super(informixInstance.getServerPlatform(), "Master Bundle", "");
        this.init(Utility.getMasterDocStream(informixInstance));
    }

    private void init(InputStream inputStream) throws Exception {
        HierarchicalParameter hierarchicalParameter = HierarchicalParameterXmlConverter.getSharedInstance().read(inputStream);
        this.setBundleName(Utility.getFirstMatching(hierarchicalParameter, "BundleName").getValue());
        this.setBundleVersion(Utility.getFirstMatching(hierarchicalParameter, "BundleVersion").getValue());
        List<HierarchicalParameter> list = Utility.getAllMatching(hierarchicalParameter, "Package");
        for (HierarchicalParameter hierarchicalParameter2 : list) {
            Package.convert(hierarchicalParameter2, this);
        }
        try {
            BundleExtension.process(this);
        }
        catch (Exception exception) {}
    }
}

