/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.informix.bundle;

import com.ibm.arcs.basic.parameter.hierarchical.HierarchicalParameter;
import com.ibm.informix.bundle.Bundle;
import com.ibm.informix.bundle.BundleMember;
import com.ibm.informix.bundle.Feature;
import com.ibm.informix.bundle.IBundleContainer;
import com.ibm.informix.bundle.Utility;
import com.ibm.informix.bundle.message.BundleMessages;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;

public class Package
implements IBundleContainer {
    static final String TAG = "Package";
    private static final String PACKAGE_NAME_TAG = "PackageName";
    String packageId;
    private final Bundle parent;
    private final Map<String, Feature> featureMap;

    Package(Bundle bundle, String string) {
        this.parent = bundle;
        this.packageId = string;
        this.featureMap = new TreeMap<String, Feature>(Utility.getComparator());
        bundle.putPackage(this);
    }

    @Override
    public String getId() {
        return this.packageId;
    }

    @Override
    public String getName() {
        return BundleMessages.getName(this.packageId);
    }

    @Override
    public String getDescription() {
        return BundleMessages.getDescription(this.packageId);
    }

    @Override
    public BundleMember getParent() {
        return null;
    }

    @Override
    public Bundle getBundle() {
        return this.parent;
    }

    @Override
    public Feature put(Feature feature) {
        this.parent.putMember(feature);
        feature.parent = this;
        return this.featureMap.put(feature.getId(), feature);
    }

    @Override
    public Feature remove(Feature feature) {
        this.parent.removeMember(feature.getId());
        return this.featureMap.remove(feature.getId());
    }

    @Override
    public Feature get(String string) {
        return this.featureMap.get(string);
    }

    public Collection<Feature> getFeatures() {
        return this.featureMap.values();
    }

    static Package convert(HierarchicalParameter hierarchicalParameter, Bundle bundle) throws Exception {
        String string = Utility.getFirstMatching(hierarchicalParameter, PACKAGE_NAME_TAG).getValue();
        Package package_ = new Package(bundle, string);
        for (HierarchicalParameter hierarchicalParameter2 : Utility.getAllMatching(hierarchicalParameter, "Feature")) {
            Feature.convert(hierarchicalParameter2, package_);
        }
        return package_;
    }
}

