/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.informix.bundle;

import com.ibm.arcs.basic.parameter.hierarchical.HierarchicalParameter;
import com.ibm.informix.bundle.Utility;
import com.ibm.informix.configuration.PlatformNameType;

class SpecificTargetName {
    private final String name;
    private final PlatformNameType[] platforms;
    static final String TAG = "SpecificTargetName";
    static final String PLATFORM_TAG = "platform";

    SpecificTargetName(String string, String[] stringArray) {
        this.name = string;
        this.platforms = new PlatformNameType[stringArray.length];
        int n = 0;
        while (n < this.platforms.length) {
            this.platforms[n] = PlatformNameType.getType((String)stringArray[n]);
            ++n;
        }
    }

    String getName() {
        return this.name;
    }

    public PlatformNameType[] getPlatforms() {
        return this.platforms;
    }

    static SpecificTargetName convert(HierarchicalParameter hierarchicalParameter) throws Exception {
        String string = Utility.getFirstMatching(hierarchicalParameter, TAG).getValue();
        String[] stringArray = hierarchicalParameter.getAttribute(PLATFORM_TAG).getValue().split("\\s+");
        return new SpecificTargetName(string, stringArray);
    }
}

