/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.informix.bundle;

import com.ibm.arcs.basic.parameter.hierarchical.HierarchicalParameter;
import com.ibm.arcs.basic.parameter.hierarchical.HierarchicalParameterSearches;
import com.ibm.arcs.basic.parameter.hierarchical.HierarchicalParameterXmlConverter;
import com.ibm.arcs.basic.strings.IStringMatcher;
import com.ibm.informix.bundle.Bundle;
import com.ibm.informix.bundle.Compare;
import com.ibm.informix.configuration.InformixInstance;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;

public class Utility {
    private static final Class<?> CLASS = new Utility().getClass();
    private static final Comparator<String> COMPARATOR = new Compare();
    private static final String MD_NAME = "/ids_master_doc.xml";
    private static final String MD_EXT_NAME = "/ids_master_doc_ext.xml";
    private static final String MD_SCHEMA_NAME = "/ids_schema.xsd";
    private static final String MD_PATH = "etc";
    private static final String INS_NAME = "/install_type.xml";

    static InputStream getMasterDocStream(InformixInstance informixInstance) {
        try {
            String string = String.valueOf(Utility.getPathWithSeparator(informixInstance.getInformixDir())) + MD_PATH + MD_NAME;
            File file = new File(string);
            if (file.exists()) {
                FileInputStream fileInputStream = new FileInputStream(file);
                InputStream inputStream = CLASS.getResourceAsStream(MD_SCHEMA_NAME);
                if (HierarchicalParameterXmlConverter.validateXmlStream((InputStream)fileInputStream, (InputStream)inputStream)) {
                    // empty if block
                }
                return new FileInputStream(file);
            }
        }
        catch (Exception exception) {}
        return Utility.getMasterDocStream();
    }

    static InputStream getMasterDocStream() {
        return CLASS.getResourceAsStream(MD_NAME);
    }

    static InputStream getMasterDocExtStream() {
        return CLASS.getResourceAsStream(MD_EXT_NAME);
    }

    static InputStream getInstallTypeStream() {
        return CLASS.getResourceAsStream(INS_NAME);
    }

    public static String getPathWithSeparator(String string) {
        if (string.endsWith(File.separator)) {
            return string;
        }
        return String.valueOf(string) + File.separator;
    }

    static List<HierarchicalParameter> getAllMatching(HierarchicalParameter hierarchicalParameter, String string) {
        return HierarchicalParameterSearches.getAllMatchingKeys((HierarchicalParameter)hierarchicalParameter, (IStringMatcher)Bundle.getMatcher(string), (int)1);
    }

    static HierarchicalParameter getFirstMatching(HierarchicalParameter hierarchicalParameter, String string) throws IllegalArgumentException {
        try {
            return HierarchicalParameterSearches.getFirstMatchingKey((HierarchicalParameter)hierarchicalParameter, (IStringMatcher)Bundle.getMatcher(string));
        }
        catch (CoreException coreException) {
            throw new IllegalArgumentException(coreException.getCause());
        }
    }

    static Comparator<String> getComparator() {
        return COMPARATOR;
    }
}

