/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.informix.bundle.message;

import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class BundleMessages {
    private static final Map<String, ResourceBundle> resources = new HashMap<String, ResourceBundle>();
    private static final String IDS_NAME = "com.ibm.informix.bundle.message.ids";
    private static final String JDBC_NAME = "com.ibm.informix.bundle.message.jdbc";
    private static final String CON_NAME = "com.ibm.informix.bundle.message.iconnect";
    private static final String SDK_NAME = "com.ibm.informix.bundle.message.csdk";
    private static final String GLS_NAME = "com.ibm.informix.bundle.message.gls";
    private static final String INSTALL_NAME = "com.ibm.informix.bundle.message.install";

    static {
        BundleMessages.add(ResourceBundle.getBundle(IDS_NAME));
        BundleMessages.add(ResourceBundle.getBundle(JDBC_NAME));
        BundleMessages.add(ResourceBundle.getBundle(CON_NAME));
        BundleMessages.add(ResourceBundle.getBundle(SDK_NAME));
        BundleMessages.add(ResourceBundle.getBundle(GLS_NAME));
        BundleMessages.add(ResourceBundle.getBundle(INSTALL_NAME));
    }

    private BundleMessages() {
    }

    private static void add(ResourceBundle resourceBundle) {
        for (String string : resourceBundle.keySet()) {
            resources.put(string, resourceBundle);
        }
    }

    public static String getName(String string) {
        String string2 = BundleMessages.getStringForKey(String.valueOf(string) + ".name");
        return string2 == null ? string : string2;
    }

    public static String getDescription(String string) {
        String string2 = BundleMessages.getStringForKey(String.valueOf(string) + ".description");
        return string2 == null ? string : string2;
    }

    public static String getString(String string) {
        String string2 = BundleMessages.getStringForKey(string);
        return string2 == null ? String.valueOf('!') + string + '!' : string2;
    }

    private static String getStringForKey(String string) {
        return BundleMessages.getStringForKey(resources.get(string), string);
    }

    private static String getStringForKey(ResourceBundle resourceBundle, String string) {
        try {
            return resourceBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }
}

