/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.informix.configuration;

import com.ibm.arcs.database.connection.ConnectionParameters;
import com.ibm.informix.configuration.EnvironmentReader;
import com.ibm.informix.configuration.EnvironmentVariable;
import com.ibm.informix.connection.InformixJdbcConnection;
import com.ibm.informix.connection.listener.InformixSystemDatabases;
import java.io.File;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;

public final class InformixServerEnvironmentVariables {
    private InformixServerEnvironmentVariables() {
    }

    public static String getInformixDirectory(ConnectionParameters connectionParameters) throws SQLException, ClassNotFoundException {
        String string = InformixServerEnvironmentVariables.getValue(connectionParameters, EnvironmentVariable.INFORMIXDIR.getDisplayName());
        try {
            string = new File(string).getCanonicalPath();
        }
        catch (IOException iOException) {}
        return string;
    }

    public static String getSQLHosts(ConnectionParameters connectionParameters) throws SQLException, ClassNotFoundException {
        String string = InformixServerEnvironmentVariables.getSQLHostsInUnix();
        return string;
    }

    private static String getSQLHostsInUnix() {
        EnvironmentReader environmentReader = new EnvironmentReader();
        String string = environmentReader.get(EnvironmentVariable.INFORMIXSQLHOSTS);
        return string;
    }

    public static String getOnconfig(ConnectionParameters connectionParameters) throws SQLException, ClassNotFoundException {
        String string = InformixServerEnvironmentVariables.getEnvironmentVariable(connectionParameters, EnvironmentVariable.ONCONFIG.getDisplayName());
        return string;
    }

    public static String getPath(ConnectionParameters connectionParameters) throws SQLException, ClassNotFoundException {
        String string = InformixServerEnvironmentVariables.getEnvironmentVariable(connectionParameters, EnvironmentVariable.PATH.getDisplayName());
        return string;
    }

    private static String getEnvironmentVariable(ConnectionParameters connectionParameters, String string) throws SQLException, ClassNotFoundException {
        String string2 = InformixServerEnvironmentVariables.getValue(connectionParameters, string);
        return string2;
    }

    public static Set<String> getAllKeys(ConnectionParameters connectionParameters) throws Exception {
        HashSet<String> hashSet = new HashSet<String>();
        String string = InformixSystemDatabases.SYSMASTER.getName();
        InformixJdbcConnection informixJdbcConnection = new InformixJdbcConnection(connectionParameters);
        informixJdbcConnection.changeDatabase(string);
        Statement statement = informixJdbcConnection.getDBConnection().createStatement();
        statement.execute("SELECT env_name FROM " + string + ":sysenv");
        ResultSet resultSet = statement.getResultSet();
        while (resultSet.next()) {
            hashSet.add(resultSet.getString(1));
        }
        statement.close();
        return hashSet;
    }

    public static String getValue(ConnectionParameters connectionParameters, String string) throws SQLException, ClassNotFoundException {
        String string2 = null;
        InformixJdbcConnection informixJdbcConnection = new InformixJdbcConnection(connectionParameters);
        informixJdbcConnection.changeDatabase(InformixSystemDatabases.SYSMASTER.getName());
        Statement statement = informixJdbcConnection.getDBConnection().createStatement();
        statement.execute("SELECT env_value FROM " + InformixSystemDatabases.SYSMASTER.getName() + ":sysenv WHERE env_name=\"" + string + "\"");
        ResultSet resultSet = statement.getResultSet();
        if (!resultSet.next()) {
            throw new IllegalArgumentException("environment variable " + string + " does not exist");
        }
        string2 = resultSet.getString(1).trim();
        statement.close();
        return string2;
    }
}

