/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.informix.configuration;

import com.ibm.arcs.basic.number.IVersion;
import com.ibm.arcs.basic.number.NaturalNumber;
import com.ibm.arcs.basic.number.WholeNumber;
import com.ibm.arcs.database.connection.ConnectionParameters;
import com.ibm.arcs.host.PlatformBits;
import com.ibm.informix.connection.InformixJdbcConnection;
import com.ibm.informix.connection.listener.InformixSystemDatabases;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class InformixVersion
implements IVersion<InformixVersion> {
    private final WholeNumber major;
    private final WholeNumber minor;
    private final WholeNumber fixpack;
    private final NaturalNumber build;
    private PlatformBits platformBits;
    private String edition;

    public InformixVersion(int n, int n2, int n3) {
        this(n, n2, n3, 1);
    }

    public InformixVersion(int n, int n2, int n3, int n4) {
        this.major = new WholeNumber(Integer.valueOf(n));
        this.minor = new WholeNumber(Integer.valueOf(n2));
        this.fixpack = new WholeNumber(Integer.valueOf(n3));
        this.build = new NaturalNumber(Integer.valueOf(n4));
    }

    public InformixVersion(int n, int n2, int n3, PlatformBits platformBits, String string) {
        this(n, n2, n3, 1);
        this.platformBits = platformBits;
        this.edition = string;
    }

    public static InformixVersion[] getAllInformixVersions() {
        InformixVersion[] informixVersionArray = new InformixVersion[]{new InformixVersion(7, 3, 0), new InformixVersion(9, 1, 0), new InformixVersion(9, 2, 0), new InformixVersion(9, 3, 0), new InformixVersion(9, 4, 0), new InformixVersion(10, 0, 0), new InformixVersion(11, 50, 1), new InformixVersion(11, 50, 2), new InformixVersion(11, 50, 3), new InformixVersion(11, 50, 4), new InformixVersion(11, 50, 5)};
        return informixVersionArray;
    }

    public static String getAllInformixVersionsToString() {
        InformixVersion[] informixVersionArray = InformixVersion.getAllInformixVersions();
        String string = "";
        InformixVersion[] informixVersionArray2 = informixVersionArray;
        int n = informixVersionArray.length;
        int n2 = 0;
        while (n2 < n) {
            InformixVersion informixVersion = informixVersionArray2[n2];
            string = String.valueOf(string) + informixVersion.getMajor() + "." + informixVersion.getMinor() + ".";
            string = informixVersion.getFixpack() == 0 ? String.valueOf(string) + "x," : String.valueOf(string) + "xC" + informixVersion.getFixpack() + ",";
            ++n2;
        }
        return string.substring(0, string.lastIndexOf(","));
    }

    public Integer getMajor() {
        return this.major.toInteger();
    }

    public Integer getMinor() {
        return this.minor.toInteger();
    }

    public Integer getService() {
        return this.fixpack.toInteger();
    }

    public Integer getFixpack() {
        return this.getService();
    }

    public Integer getBuild() {
        return this.build.toInteger();
    }

    public PlatformBits getPlatformBits() {
        return this.platformBits;
    }

    public int compareTo(InformixVersion informixVersion) {
        if (this == informixVersion) {
            return 0;
        }
        int n = this.major.compareTo(informixVersion.major);
        int n2 = this.minor.compareTo(informixVersion.minor);
        int n3 = this.fixpack.compareTo(informixVersion.fixpack);
        int n4 = this.build.compareTo(informixVersion.build);
        if (n <= 0 && n2 <= 0 && n3 <= 0 && n4 <= 0) {
            if (n == 0 && n2 == 0 && n3 == 0 && n4 == 0) {
                return 0;
            }
            return -1;
        }
        return 1;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.build.hashCode();
        n = 31 * n + this.fixpack.hashCode();
        n = 31 * n + this.major.hashCode();
        n = 31 * n + this.minor.hashCode();
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        InformixVersion informixVersion = (InformixVersion)object;
        return this.major.equals((Object)informixVersion.major) && this.minor.equals((Object)informixVersion.minor) && this.fixpack.equals((Object)informixVersion.fixpack) && this.build.equals((Object)informixVersion.build);
    }

    public static InformixVersion getInformixVersion(ConnectionParameters connectionParameters) throws SQLException, ClassNotFoundException {
        InformixVersion informixVersion = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        PlatformBits platformBits = null;
        InformixJdbcConnection informixJdbcConnection = new InformixJdbcConnection(connectionParameters);
        String string = InformixSystemDatabases.SYSMASTER.getName();
        informixJdbcConnection.changeDatabase(string);
        Statement statement = informixJdbcConnection.getDBConnection().createStatement();
        statement.execute("SELECT DBINFO('version', 'major'), DBINFO('version', 'minor'), DBINFO('version', 'level'), DBINFO('version', 'os') FROM " + string + ":systables WHERE tabid = 1");
        ResultSet resultSet = statement.getResultSet();
        if (resultSet.next()) {
            n = resultSet.getInt(1);
            n2 = resultSet.getInt(2);
            String string2 = resultSet.getString(3).substring(1);
            try {
                n3 = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {}
            platformBits = resultSet.getString(4).trim().equalsIgnoreCase("F") ? PlatformBits.SixtyFour : PlatformBits.ThirtyTwo;
            informixVersion = new InformixVersion(n, n2, n3, platformBits, string2);
        }
        statement.close();
        return informixVersion;
    }

    public String getVersionString() {
        return this.major.value + "." + this.minor.value + (this.edition.length() == 0 ? "" : "." + (this.fixpack.value == 0 ? this.edition : this.fixpack.value));
    }
}

