/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.informix.configuration;

import com.ibm.arcs.host.ISAType;
import com.ibm.arcs.host.KernelType;
import com.ibm.arcs.host.PlatformBits;
import com.ibm.informix.configuration.Platform;

public enum PlatformNameType {
    nt_intel(KernelType.Windows, PlatformBits.ThirtyTwo, ISAType.x86),
    win64_amd(KernelType.Windows, PlatformBits.SixtyFour, ISAType.x86),
    linux32(KernelType.Linux, PlatformBits.ThirtyTwo, ISAType.x86),
    linux86_64(KernelType.Linux, PlatformBits.SixtyFour, ISAType.x86),
    solx86_64(KernelType.SunOS, PlatformBits.SixtyFour, ISAType.x86),
    solaris(KernelType.SunOS, PlatformBits.ThirtyTwo, ISAType.SPARC),
    sol64(KernelType.SunOS, PlatformBits.SixtyFour, ISAType.SPARC),
    hp11(KernelType.HPUX, PlatformBits.ThirtyTwo, ISAType.x86),
    hp64(KernelType.HPUX, PlatformBits.SixtyFour, ISAType.x86),
    hpia32(KernelType.HPUX, PlatformBits.ThirtyTwo, ISAType.Itanium),
    hpia64(KernelType.HPUX, PlatformBits.SixtyFour, ISAType.Itanium),
    ibmrs6000(KernelType.AIX, PlatformBits.ThirtyTwo, ISAType.POWER),
    ibm64(KernelType.AIX, PlatformBits.SixtyFour, ISAType.POWER),
    macosx32(KernelType.Darwin, PlatformBits.ThirtyTwo, ISAType.x86),
    macosx64(KernelType.Darwin, PlatformBits.SixtyFour, ISAType.x86),
    linuxppc64(KernelType.Linux, PlatformBits.SixtyFour, ISAType.POWER),
    linuxia64(KernelType.Linux, PlatformBits.SixtyFour, ISAType.Itanium),
    zlinux32(KernelType.Linux, PlatformBits.ThirtyTwo, ISAType.x86),
    zlinux64(KernelType.Linux, PlatformBits.SixtyFour, ISAType.x86),
    intel_solaris(KernelType.SunOS, null, ISAType.x86),
    all(KernelType.UNKNOWN, null, null),
    all_unix32(KernelType.UNKNOWN, PlatformBits.ThirtyTwo, null),
    all_unix64(KernelType.UNKNOWN, PlatformBits.SixtyFour, null),
    all_win(KernelType.Windows, null, null);

    private final KernelType kernelType;
    private final PlatformBits platformBits;
    private final ISAType isaType;

    private PlatformNameType(KernelType kernelType, PlatformBits platformBits, ISAType iSAType) {
        this.kernelType = kernelType;
        this.platformBits = platformBits;
        this.isaType = iSAType;
    }

    public static PlatformNameType getType(String string) {
        return PlatformNameType.valueOf(string.replaceAll("[.-]", "_"));
    }

    public KernelType getKernelType() {
        return this.kernelType;
    }

    public PlatformBits getOEBits() {
        return this.platformBits;
    }

    public ISAType getISAType() {
        return this.isaType;
    }

    public boolean matches(KernelType kernelType, PlatformBits platformBits, ISAType iSAType) {
        switch (this) {
            case all: {
                return true;
            }
            case all_unix32: {
                return kernelType.isUnix() && platformBits == PlatformBits.ThirtyTwo;
            }
            case all_unix64: {
                return kernelType.isUnix() && platformBits == PlatformBits.SixtyFour;
            }
            case all_win: {
                return kernelType == KernelType.Windows;
            }
        }
        return this.kernelType == kernelType && this.platformBits == platformBits && this.isaType == iSAType;
    }

    public static PlatformNameType getPlatformNameType(Platform platform) {
        PlatformNameType[] platformNameTypeArray = PlatformNameType.values();
        int n = platformNameTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            PlatformNameType platformNameType = platformNameTypeArray[n2];
            if (platformNameType.kernelType == platform.getKernelType() && platformNameType.platformBits == platform.getPlatformBits() && platformNameType.isaType == platform.getIsaType()) {
                return platformNameType;
            }
            ++n2;
        }
        return null;
    }

    public boolean isUnix() {
        switch (this) {
            case nt_intel: 
            case win64_amd: 
            case all_win: {
                return false;
            }
        }
        return true;
    }
}

