/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.informix.configuration;

import com.ibm.arcs.basic.strings.ParameterParse;
import com.ibm.arcs.basic.tuple.Triple;
import com.ibm.arcs.host.Host;
import com.ibm.arcs.host.HostCatalog;
import com.ibm.arcs.host.HostName;
import com.ibm.arcs.host.HostPort;
import com.ibm.informix.configuration.network.ISQLHostsReader;
import com.ibm.informix.configuration.network.ServicesReader;
import com.ibm.informix.connection.InformixDatabaseServerName;
import com.ibm.informix.connection.listener.InformixServerConnectionType;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.HashMap;
import java.util.Scanner;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLHostsFileReader
implements ISQLHostsReader {
    private final HashMap<InformixDatabaseServerName, Triple<InformixServerConnectionType, HostName, HostPort>> sqlHosts = new HashMap();
    private Scanner fileIn;
    private static final String SERVICES_FILE_NAME = "/etc/services";
    private final Logger logger;

    public SQLHostsFileReader(String string) {
        InformixDatabaseServerName informixDatabaseServerName = null;
        this.logger = LoggerFactory.getLogger(SQLHostsFileReader.class);
        try {
            this.fileIn = new Scanner(new FileReader(string));
            while (this.fileIn.hasNext()) {
                Object object2;
                String string2 = this.fileIn.nextLine();
                Pattern pattern = Pattern.compile("#+?");
                Matcher matcher = pattern.matcher(string2);
                if (matcher.find()) {
                    string2 = string2.substring(0, string2.indexOf("#")).trim();
                }
                if (string2.equals("")) continue;
                if (string2.contains("\t") && (matcher = (pattern = Pattern.compile("\t+?")).matcher(string2)).find()) {
                    string2 = matcher.replaceAll(" ");
                }
                if (string2.contains(" ")) {
                    try {
                        informixDatabaseServerName = new InformixDatabaseServerName(string2.substring(0, string2.indexOf(" ")).trim());
                        string2 = string2.substring(string2.indexOf(" ")).trim();
                    }
                    catch (Exception exception) {}
                } else {
                    try {
                        informixDatabaseServerName = new InformixDatabaseServerName(string2.trim());
                        string2 = "";
                    }
                    catch (Exception exception) {}
                }
                String string3 = !string2.equals("") ? string2.trim() : "";
                String[] stringArray = ParameterParse.parseParameters((String)string3);
                if (stringArray.length != 3) {
                    throw new RuntimeException("SQL Hosts file has more than 4 columns");
                }
                this.logger.debug(String.valueOf(informixDatabaseServerName.getName()) + " " + stringArray[0] + " " + stringArray[1] + " " + stringArray[2]);
                Host[] hostArray = HostCatalog.getAllHostsWithName((String)stringArray[1]);
                HostName hostName = null;
                if (hostArray.length > 0) {
                    for (Object object2 : hostArray[0].getHostNames()) {
                        if (object2.getName() != stringArray[1]) continue;
                        hostName = object2;
                        break;
                    }
                } else {
                    hostName = HostCatalog.getNewHost().addHostName(stringArray[1]);
                }
                object2 = new ServicesReader(SERVICES_FILE_NAME, stringArray[2]);
                this.sqlHosts.put(informixDatabaseServerName, (Triple<InformixServerConnectionType, HostName, HostPort>)new Triple((Object)InformixServerConnectionType.valueOf((String)stringArray[0]), (Object)hostName, (Object)new HostPort(((ServicesReader)object2).getHostPort().getHostPortNumber())));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("Cannot open sqlhosts file.");
        }
    }

    public HashMap<InformixDatabaseServerName, Triple<InformixServerConnectionType, HostName, HostPort>> getSQLHostsParameters() {
        return this.sqlHosts;
    }

    @Override
    public Set<InformixDatabaseServerName> getKeySet() {
        return this.sqlHosts.keySet();
    }

    @Override
    public Triple<InformixServerConnectionType, HostName, HostPort> getValue(InformixDatabaseServerName informixDatabaseServerName) {
        return this.sqlHosts.get(informixDatabaseServerName);
    }
}

