/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.informix.configuration.logging;

import com.ibm.arcs.basic.unit.ByteUnit;
import com.ibm.arcs.basic.unit.ByteValue;

public class LogicalLog {
    private ByteValue logSize;
    private int logFiles;
    private ByteValue bufferSize;
    private ByteValue dynamicLogs;

    public ByteValue getLogSize() {
        return this.logSize;
    }

    public int getNumberLogs() {
        return this.logFiles;
    }

    public ByteValue getBufferSize() {
        return this.bufferSize;
    }

    public ByteValue getDynamicLogs() {
        return this.dynamicLogs;
    }

    private void setDefaultValues() {
        this.logSize = new ByteValue(10000L, ByteUnit.KILOBYTE);
        this.logFiles = 6;
        this.bufferSize = new ByteValue(64L, ByteUnit.BYTE);
        this.dynamicLogs = new ByteValue(2L, ByteUnit.KILOBYTE);
    }

    public static String getHelp(LogicalLogFields logicalLogFields) {
        switch (logicalLogFields) {
            case LOGFILES: {
                return "The number of logical log files";
            }
            case LOGSIZE: {
                return "The size of each logical log, in KB";
            }
            case LOGBUFF: {
                return "The type of dynamic log allocation.\nAcceptable values are:\n 2 Automatic. IDS adds a new logical log to the root dbspace when necessary. 1 Manual. IDS notifies the DBA to add new logical logs when necessary. 0 Disabled";
            }
            case DYNAMIC_LOGS: {
                return "The size of the logical log buffer, in KB";
            }
        }
        throw new AssertionError((Object)"Invalid field specified");
    }

    public static enum LogicalLogFields {
        LOGFILES,
        LOGSIZE,
        DYNAMIC_LOGS,
        LOGBUFF;

    }
}

