/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.informix.configuration.network;

import com.ibm.arcs.host.HostName;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.NoSuchElementException;
import java.util.Scanner;

public class HostReader {
    private Scanner fileIn;
    private InetAddress ip = null;
    private String description = null;

    public HostReader(String string, HostName hostName) throws UnknownHostException {
        try {
            this.fileIn = new Scanner(new FileReader(string));
            String string2 = null;
            while ((string2 = this.fileIn.nextLine()) != null) {
                if (!string2.contains(hostName.getName())) continue;
                String[] stringArray = string2.split("\t");
                this.ip = InetAddress.getByAddress(hostName.getName(), stringArray[0].getBytes());
                try {
                    this.description = stringArray[2];
                }
                catch (NullPointerException nullPointerException) {}
            }
            if (this.ip == null) {
                this.ip = InetAddress.getByName(hostName.getName());
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("Cannot open hosts file.");
        }
        catch (UnknownHostException unknownHostException) {
            throw unknownHostException;
        }
        catch (NoSuchElementException noSuchElementException) {}
    }

    public InetAddress getInetAddress() {
        return this.ip;
    }

    public String getDescription() {
        return this.description;
    }
}

