/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.informix.configuration.network;

public class LimitNumberOfSessions {
    private static final String CLASSTYPE = "LIMITNUMSESSIONS";
    private int maxConnections;
    private boolean logging;

    private LimitNumberOfSessions() {
    }

    LimitNumberOfSessions(int n, boolean bl) throws Exception {
        this();
        this.setMaxConnections(n);
        this.logging = bl;
    }

    void setMaxConnections(int n) throws Exception {
        if (n <= 0) {
            if (n == 0) {
                throw new Exception("This is possible, but only DBSA's will be able to connection to this Dynamic Server.");
            }
            throw new Exception("You can only have a positive number of Max Connections.");
        }
        this.maxConnections = n;
    }

    int getMaxConnections() {
        return this.maxConnections;
    }

    void setLogging(boolean bl) {
        this.logging = bl;
    }

    int getLogging() throws Exception {
        if (this.logging) {
            return 1;
        }
        throw new Exception("Logging is turned off and there is no number that represents when loggins turned off.\nPlease check isLogging before trying to obtain a logging indicator.");
    }

    public boolean isLogging() {
        return this.logging;
    }

    public String getLimitNumSessionsConfigurationParameter() throws Exception {
        String string = null;
        string = new String(String.valueOf(Integer.toString(this.maxConnections)) + "," + this.getLogging());
        return string;
    }

    public String getClassParameterType() {
        return CLASSTYPE;
    }
}

