/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.informix.configuration.network;

import com.ibm.arcs.basic.tuple.ImmutablePair;
import com.ibm.arcs.basic.tuple.Triple;
import com.ibm.arcs.host.Host;
import com.ibm.arcs.host.HostCatalog;
import com.ibm.arcs.host.HostName;
import com.ibm.arcs.host.HostPort;
import com.ibm.arcs.windows.registry.RegistryAction;
import com.ibm.arcs.windows.registry.RegistryCommand;
import com.ibm.arcs.windows.registry.RegistryKey;
import com.ibm.arcs.windows.registry.RegistryPath;
import com.ibm.arcs.windows.registry.RegistryRoot;
import com.ibm.arcs.windows.registry.RegistryValue;
import com.ibm.arcs.windows.registry.WindowsRegistryReader;
import com.ibm.informix.configuration.network.ISQLHostsReader;
import com.ibm.informix.configuration.network.ServicesReader;
import com.ibm.informix.configuration.network.WindowsPaths;
import com.ibm.informix.connection.InformixDatabaseServerName;
import com.ibm.informix.connection.listener.InformixServerConnectionType;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class SQLHostsRegistryReader
implements ISQLHostsReader {
    private static final String SQL_HOSTS_PATH = "Software\\Informix\\SQLHosts";
    private Map<InformixDatabaseServerName, Triple<InformixServerConnectionType, HostName, HostPort>> sqlHosts = new HashMap<InformixDatabaseServerName, Triple<InformixServerConnectionType, HostName, HostPort>>();

    public SQLHostsRegistryReader(String string) throws Exception {
        this(String.valueOf(WindowsPaths.WINDIR.getPath()) + WindowsPaths.hosts.getPath(), String.valueOf(WindowsPaths.WINDIR.getPath()) + WindowsPaths.services.getPath());
    }

    public SQLHostsRegistryReader(String string, String string2) throws Exception {
        InformixDatabaseServerName informixDatabaseServerName = null;
        InformixServerConnectionType informixServerConnectionType = null;
        HostName hostName = null;
        RegistryPath registryPath = new RegistryPath(SQL_HOSTS_PATH, RegistryRoot.HKEY_LOCAL_MACHINE);
        RegistryCommand registryCommand = new RegistryCommand(RegistryAction.Query, RegistryRoot.HKEY_LOCAL_MACHINE, registryPath);
        WindowsRegistryReader windowsRegistryReader = WindowsRegistryReader.getInstance();
        for (RegistryKey registryKey : windowsRegistryReader.readKeys(registryCommand).getSubKeys()) {
            informixDatabaseServerName = new InformixDatabaseServerName(registryKey.getKeyName());
            registryCommand = new RegistryCommand(RegistryAction.Query, RegistryRoot.HKEY_LOCAL_MACHINE, registryKey.getKeyPath());
            Vector vector = windowsRegistryReader.readValues(registryCommand).getTypedValues();
            ServicesReader servicesReader = null;
            for (ImmutablePair immutablePair : vector) {
                RegistryValue registryValue = (RegistryValue)immutablePair.getSecond();
                String string3 = registryValue.getName().toLowerCase();
                if (string3.contains("host")) {
                    String string4 = registryValue.getValue().charAt(0) == '*' ? registryValue.getValue().substring(1, registryValue.getValue().length()) : registryValue.getValue();
                    Host[] hostArray = HostCatalog.getAllHostsWithName((String)string4);
                    if (hostArray.length > 0) {
                        for (HostName hostName2 : hostArray[0].getHostNames()) {
                            if (!hostName2.getName().equalsIgnoreCase(string4)) continue;
                            hostName = hostName2;
                            break;
                        }
                    } else {
                        hostName = HostCatalog.getNewHost().addHostName(string4);
                    }
                }
                if (string3.contains("protocol")) {
                    informixServerConnectionType = InformixServerConnectionType.valueOf((String)registryValue.getValue());
                    continue;
                }
                if (!string3.contains("service")) continue;
                servicesReader = new ServicesReader(string2, registryValue.getValue());
            }
            if (servicesReader == null) continue;
            this.sqlHosts.put(informixDatabaseServerName, (Triple<InformixServerConnectionType, HostName, HostPort>)new Triple(informixServerConnectionType, hostName, (Object)servicesReader.getHostPort()));
        }
    }

    @Override
    public Set<InformixDatabaseServerName> getKeySet() {
        return this.sqlHosts.keySet();
    }

    @Override
    public Map<InformixDatabaseServerName, Triple<InformixServerConnectionType, HostName, HostPort>> getSQLHostsParameters() {
        return this.sqlHosts;
    }

    @Override
    public Triple<InformixServerConnectionType, HostName, HostPort> getValue(InformixDatabaseServerName informixDatabaseServerName) {
        return this.sqlHosts.get(informixDatabaseServerName);
    }

    public static void main(String[] stringArray) {
        HostCatalog.getLocalHost();
        SQLHostsRegistryReader sQLHostsRegistryReader = null;
        try {
            sQLHostsRegistryReader = new SQLHostsRegistryReader(String.valueOf(WindowsPaths.WINDIR.getPath()) + WindowsPaths.hosts.getPath(), String.valueOf(WindowsPaths.WINDIR.getPath()) + WindowsPaths.services.getPath());
        }
        catch (Exception exception) {}
        for (InformixDatabaseServerName informixDatabaseServerName : sQLHostsRegistryReader.getKeySet()) {
            System.out.println(informixDatabaseServerName.getName());
            Triple<InformixServerConnectionType, HostName, HostPort> triple = sQLHostsRegistryReader.getValue(informixDatabaseServerName);
            System.out.println("Connection Type:\t" + triple.getFirst());
            System.out.println("Host:\t" + ((HostName)triple.getSecond()).getName());
            System.out.println("Port:\t" + ((HostPort)triple.getThird()).getHostPortNumber());
        }
    }
}

