/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.informix.configuration.network;

import com.ibm.informix.configuration.network.NettypeVirtualProcessorClass;
import com.ibm.informix.connection.listener.InformixListenerParameters;

public class ServerListenerParameters {
    private InformixListenerParameters informixListenerParameters;
    private int numOfPollThreads;
    private static final int numOfPollThreads_MIN = 1;
    private static int numOfPollThreads_MAX = 100;
    private int numOfConnections;
    private static int numOfConnections_MIN_PER_POLL_THREAD = 1;
    private static int numOfConnections_MAX_PER_POLL_THREAD = 350;
    private static final int numOfConnections_DEFAULT = 50;
    private NettypeVirtualProcessorClass nettypeVPClass;

    public ServerListenerParameters(InformixListenerParameters informixListenerParameters) {
        this.informixListenerParameters = informixListenerParameters;
        this.setDefaults();
    }

    private void setDefaults() {
        this.numOfPollThreads = 1;
        this.numOfConnections = 50;
        this.nettypeVPClass = NettypeVirtualProcessorClass.NET;
    }

    public void setListenerParameters(InformixListenerParameters informixListenerParameters) {
        this.informixListenerParameters = informixListenerParameters;
    }

    public InformixListenerParameters getListenerParameters() {
        return this.informixListenerParameters;
    }

    public void setNumOfPollThreads(int n) throws Exception {
        if (n < 1 || n > numOfPollThreads_MAX) {
            throw new Exception("The number provided for the Number Of Poll Threads is out of range [1-" + numOfPollThreads_MAX + "]");
        }
        this.numOfPollThreads = n;
    }

    public int getNumOfPollThreads() {
        return this.numOfPollThreads;
    }

    public void setNumOfPollThreads_MAX(int n) {
        numOfPollThreads_MAX = n;
    }

    public int getNumOfPollThreads_MAX() {
        return this.numOfPollThreads;
    }

    public void setNumOfConnections(int n, boolean bl) throws Exception {
        if (bl) {
            if (n < numOfConnections_MIN_PER_POLL_THREAD) {
                throw new Exception("The provided Number of Connections is below the minimum amount: min =  " + numOfConnections_MIN_PER_POLL_THREAD);
            }
            this.numOfConnections = n;
        } else {
            if (n / this.numOfPollThreads < numOfConnections_MIN_PER_POLL_THREAD) {
                throw new Exception("The provided Number of Connections is below the minimun amount per poll thread: min = " + numOfConnections_MIN_PER_POLL_THREAD + " per poll thread");
            }
            this.numOfConnections = n / this.numOfPollThreads;
        }
    }

    public int getNumOfConnectionsPerPollThread() {
        return this.numOfConnections;
    }

    public void setVPClass(NettypeVirtualProcessorClass nettypeVirtualProcessorClass) {
    }

    public NettypeVirtualProcessorClass getNettypeVPClass() {
        return this.nettypeVPClass;
    }
}

