/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.informix.connection;

import com.ibm.arcs.database.connection.AbstractConnectionParametersBuilder;
import com.ibm.informix.connection.InformixDatabaseServerName;
import com.ibm.informix.connection.listener.InformixServerConnectionType;
import com.ibm.informix.identifier.InformixDatabaseName;

public abstract class InformixConnectionParametersBuilder
extends AbstractConnectionParametersBuilder {
    private InformixServerConnectionType informixServerConnectionType = InformixServerConnectionType.onsoctcp;

    public InformixConnectionParametersBuilder() {
        this.setDatabaseName("");
    }

    public void setInformixServerConnectionType(InformixServerConnectionType informixServerConnectionType) {
        this.informixServerConnectionType = informixServerConnectionType;
    }

    public InformixServerConnectionType getInformixServerConnectionType() {
        return this.informixServerConnectionType;
    }

    public void setDatabaseName(String string) {
        this.setDatabaseName(new InformixDatabaseName(string));
    }

    public void setDatabaseServerName(String string) {
        this.setDatabaseServerName(new InformixDatabaseServerName(string));
    }

    public InformixDatabaseServerName getDatabaseServerName() {
        return (InformixDatabaseServerName)super.getDatabaseServerName();
    }

    protected boolean validate() {
        return this.validateUserName() && this.validateUserPassword() && this.validateHostName() && this.validateHostPort() && this.validateDatabaseName() && this.validateDatabaseServerName() && this.validateDatabaseProtocol();
    }

    private boolean validateUserName() {
        if (!this.isNonNull(this.getUserName())) {
            throw new IllegalArgumentException("Username must not be null");
        }
        return true;
    }

    private boolean validateUserPassword() {
        if (!this.isNonNull(this.getUserPassword())) {
            throw new IllegalArgumentException("Password must not be null");
        }
        return true;
    }

    private boolean validateHostName() {
        if (!this.isNonNull(this.getHostName())) {
            throw new IllegalArgumentException("Host name must not be null");
        }
        return true;
    }

    private boolean validateHostPort() {
        if (!this.isNonNull(this.getHostPort())) {
            throw new IllegalArgumentException("Host port must not be null");
        }
        return true;
    }

    private boolean validateDatabaseName() {
        if (!this.isNonNull(this.getDatabaseName())) {
            throw new IllegalArgumentException("Database name must not be null");
        }
        return true;
    }

    private boolean validateDatabaseServerName() {
        if (!this.isNonNull(this.getDatabaseName())) {
            throw new IllegalArgumentException("Database server name must not be null");
        }
        return true;
    }

    private boolean validateDatabaseProtocol() {
        if (!this.isNonNull(this.getDatabaseProtocol())) {
            throw new IllegalArgumentException("Database protocol must not be null");
        }
        return true;
    }

    private boolean isNonNull(Object object) {
        return object != null;
    }

    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + (this.informixServerConnectionType == null ? 0 : this.informixServerConnectionType.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (!(object instanceof InformixConnectionParametersBuilder)) {
            return false;
        }
        InformixConnectionParametersBuilder informixConnectionParametersBuilder = (InformixConnectionParametersBuilder)((Object)object);
        return this.informixServerConnectionType == informixConnectionParametersBuilder.informixServerConnectionType;
    }
}

