/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.informix.connection;

import com.ibm.arcs.basic.node.Node;
import com.ibm.arcs.basic.node.NodeSearches;
import com.ibm.arcs.basic.node.matcher.NodeMatcher;
import com.ibm.arcs.basic.parameter.hierarchical.HierarchicalParameter;
import com.ibm.arcs.basic.parameter.hierarchical.HierarchicalParameterSearches;
import com.ibm.arcs.basic.parameter.hierarchical.matcher.HierarchicalParameterMatcher;
import com.ibm.arcs.basic.strings.IStringMatcher;
import com.ibm.arcs.basic.strings.StringMatcherExact;
import com.ibm.arcs.database.DatabaseProtocol;
import com.ibm.arcs.database.DatabaseProtocols;
import com.ibm.arcs.database.connection.ConnectionParametersBuilder;
import com.ibm.arcs.database.connection.ConnectionParametersKeys;
import com.ibm.arcs.database.connection.listener.ListenerParametersConverter;
import com.ibm.arcs.serialization.xml.AbstractXmlSerializer;
import com.ibm.arcs.serialization.xml.catalog.XmlSerializerCatalog;
import com.ibm.arcs.serialization.xml.serializer.ObjectSerializer;
import com.ibm.informix.connection.InformixConnectionParameters;
import com.ibm.informix.connection.listener.InformixListenerParameters;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class InformixConnectionParametersXmlSerializer
extends AbstractXmlSerializer {
    public boolean accepts(Class<?> clazz) {
        return InformixConnectionParameters.class.isAssignableFrom(clazz);
    }

    public HierarchicalParameter toHierarchicalParameter(Object object, XmlSerializerCatalog xmlSerializerCatalog) {
        if (this.accepts(object.getClass())) {
            InformixConnectionParameters informixConnectionParameters = (InformixConnectionParameters)object;
            HierarchicalParameter hierarchicalParameter = ObjectSerializer.createRootNode(object.getClass(), (XmlSerializerCatalog)xmlSerializerCatalog);
            new HierarchicalParameter(ConnectionParametersKeys.DatabaseProtocol.getKey(), informixConnectionParameters.getDatabaseProtocol().getJdbcSubProtocol(), hierarchicalParameter);
            new HierarchicalParameter(ConnectionParametersKeys.HostName.getKey(), informixConnectionParameters.getHostName().getName(), hierarchicalParameter);
            new HierarchicalParameter(ConnectionParametersKeys.PortNumber.getKey(), Integer.toString(informixConnectionParameters.getHostPort().getHostPortNumber()), hierarchicalParameter);
            new HierarchicalParameter(ConnectionParametersKeys.DatabaseServerName.getKey(), informixConnectionParameters.getDatabaseServerName().getName(), hierarchicalParameter);
            new HierarchicalParameter(ConnectionParametersKeys.DatabaseName.getKey(), informixConnectionParameters.getDatabaseName().getName(), hierarchicalParameter);
            new HierarchicalParameter(ConnectionParametersKeys.UserName.getKey(), informixConnectionParameters.getUserName(), hierarchicalParameter);
            new HierarchicalParameter(ConnectionParametersKeys.Password.getKey(), informixConnectionParameters.getUserPassword(), hierarchicalParameter);
            for (String string : informixConnectionParameters.getJdbcParameters()) {
                new HierarchicalParameter(ConnectionParametersKeys.ExtraJdbcParameters.getKey(), string, hierarchicalParameter);
            }
            return hierarchicalParameter;
        }
        throw new IllegalArgumentException("incompatible classes");
    }

    public Object fromXml(HierarchicalParameter hierarchicalParameter, XmlSerializerCatalog xmlSerializerCatalog) throws CoreException {
        try {
            String string = InformixConnectionParametersXmlSerializer.getParameter(ConnectionParametersKeys.DatabaseProtocol.getMatcher(), hierarchicalParameter);
            DatabaseProtocol databaseProtocol = DatabaseProtocols.getDatabaseProtocol((String)string);
            ConnectionParametersBuilder connectionParametersBuilder = databaseProtocol.getConnectionParametersBuilder();
            connectionParametersBuilder.setHostName(InformixConnectionParametersXmlSerializer.getParameter(ConnectionParametersKeys.HostName.getMatcher(), hierarchicalParameter));
            connectionParametersBuilder.setHostPort(Integer.parseInt(InformixConnectionParametersXmlSerializer.getParameter(ConnectionParametersKeys.PortNumber.getMatcher(), hierarchicalParameter)));
            connectionParametersBuilder.setDatabaseServerName(InformixConnectionParametersXmlSerializer.getParameter(ConnectionParametersKeys.DatabaseServerName.getMatcher(), hierarchicalParameter));
            connectionParametersBuilder.setUserName(InformixConnectionParametersXmlSerializer.getParameter(ConnectionParametersKeys.UserName.getMatcher(), hierarchicalParameter));
            connectionParametersBuilder.setUserPassword(InformixConnectionParametersXmlSerializer.getParameter(ConnectionParametersKeys.Password.getMatcher(), hierarchicalParameter));
            connectionParametersBuilder.setDatabaseName(InformixConnectionParametersXmlSerializer.getParameter(ConnectionParametersKeys.DatabaseName.getMatcher(), hierarchicalParameter));
            connectionParametersBuilder.addJdbcParameter(InformixConnectionParametersXmlSerializer.getExtraParams(ConnectionParametersKeys.ExtraJdbcParameters.getMatcher(), hierarchicalParameter));
            return connectionParametersBuilder.getConnectionParameters();
        }
        catch (Exception exception) {
            throw new CoreException((IStatus)new Status(4, "com.ibm.informix.connection", "Unable to create InformixConnectionParameters from specified HierarchicalParameter", (Throwable)exception));
        }
    }

    private static InformixListenerParameters getListenerParams(HierarchicalParameter hierarchicalParameter, XmlSerializerCatalog xmlSerializerCatalog) throws CoreException {
        HierarchicalParameter hierarchicalParameter2 = InformixConnectionParametersXmlSerializer.getStartOfListenerParameters(hierarchicalParameter);
        ListenerParametersConverter listenerParametersConverter = new ListenerParametersConverter();
        return (InformixListenerParameters)listenerParametersConverter.fromXml(hierarchicalParameter2, xmlSerializerCatalog);
    }

    private static HierarchicalParameter getStartOfListenerParameters(HierarchicalParameter hierarchicalParameter) throws CoreException {
        StringMatcherExact stringMatcherExact = new StringMatcherExact("com.ibm.arcs.database.ListenerParameters");
        List list = HierarchicalParameterSearches.getAllMatchingKeys((HierarchicalParameter)hierarchicalParameter, (IStringMatcher)stringMatcherExact, (int)1);
        if (list.size() != 1) {
            throw new CoreException((IStatus)new Status(4, "com.ibm.informix.connection", "incorrect number of listener parameters"));
        }
        return list.toArray(new HierarchicalParameter[list.size()])[0];
    }

    private static String getParameter(HierarchicalParameterMatcher hierarchicalParameterMatcher, HierarchicalParameter hierarchicalParameter) throws CoreException {
        return HierarchicalParameterSearches.getValueOfMatchingChild((HierarchicalParameter)hierarchicalParameter, (HierarchicalParameterMatcher)hierarchicalParameterMatcher);
    }

    private static List<String> getExtraParams(HierarchicalParameterMatcher hierarchicalParameterMatcher, HierarchicalParameter hierarchicalParameter) {
        List list = NodeSearches.getAllMatching((Node)hierarchicalParameter, (NodeMatcher)hierarchicalParameterMatcher, (int)1);
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (HierarchicalParameter hierarchicalParameter2 : list) {
            String string = hierarchicalParameter2.getValue();
            arrayList.add(string);
        }
        return arrayList;
    }
}

