/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.informix.connection;

import com.ibm.arcs.database.connection.ConnectionParameters;
import com.ibm.arcs.database.connection.ConnectionParametersBuilder;
import com.ibm.arcs.database.connection.IConnection;
import com.ibm.arcs.database.connection.JdbcDriversProperty;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InformixJdbcConnection
implements IConnection {
    private final Logger logger = LoggerFactory.getLogger(InformixJdbcConnection.class);
    private Connection con;
    private DatabaseMetaData dbmd;
    private ConnectionParameters cp;
    private boolean isConnected;
    private static String errorMessage = null;
    private static Integer errorCode = null;

    public InformixJdbcConnection(ConnectionParameters connectionParameters) {
        if (!connectionParameters.isNetworkCapable()) {
            throw new IllegalArgumentException("Connection to '" + connectionParameters.getUrl() + "' is not network capable");
        }
        this.cp = connectionParameters;
        this.isConnected = false;
    }

    public Connection getDBConnection() {
        return this.con;
    }

    public synchronized ConnectionParameters getConnectionParameters() {
        return this.cp;
    }

    public boolean commit() {
        return false;
    }

    public synchronized boolean connect() throws SQLException, ClassNotFoundException {
        if (!this.isConnected) {
            try {
                this.con = this.cp.getConnection();
                this.dbmd = this.con.getMetaData();
                if (this.dbmd.supportsTransactions()) {
                    this.con.setAutoCommit(true);
                }
                this.isConnected = true;
            }
            catch (SQLException sQLException) {
                this.logSQLException("SQLException while connecting", sQLException);
                throw sQLException;
            }
        }
        return this.isConnected;
    }

    public synchronized boolean disconnect() {
        this.isConnected = false;
        try {
            if (this.dbmd != null && this.dbmd.supportsTransactions()) {
                this.con.commit();
            }
        }
        catch (SQLException sQLException) {
            this.logSQLException("SQLException while committing transaction", sQLException);
        }
        try {
            if (this.con != null) {
                this.con.close();
            }
        }
        catch (SQLException sQLException) {
            this.logSQLException("SQLException while closing connection", sQLException);
        }
        this.con = null;
        this.dbmd = null;
        return this.isConnected;
    }

    public synchronized boolean isConnected() {
        return this.isConnected;
    }

    public synchronized String toString() {
        return "{URL:" + this.cp.getUrlWithHiddenPassword() + "}";
    }

    private void logSQLException(String string, SQLException sQLException) {
        SQLException sQLException2 = sQLException;
        this.logger.error(string);
        while (sQLException2 != null) {
            this.logger.error("Error msg: " + sQLException2.getMessage());
            this.logger.error("SQLSTATE: " + sQLException2.getSQLState());
            this.logger.error("Error code: " + sQLException2.getErrorCode());
            errorMessage = sQLException2.getMessage();
            errorCode = sQLException2.getErrorCode();
            sQLException2 = sQLException2.getNextException();
        }
        sQLException2 = null;
    }

    public String getServerName() {
        this.logger.debug("getServerName()");
        try {
            Statement statement = this.con.createStatement();
            String string = "select first 1 dbservername from sysmaster:sysdatabases;";
            this.logger.debug("Executing SQL:" + string);
            ResultSet resultSet = statement.executeQuery(string);
            if (resultSet.next()) {
                System.out.println("DB Servername = " + resultSet.getString(1));
                return resultSet.getString(1);
            }
            return "Unknown";
        }
        catch (SQLException sQLException) {
            this.logSQLException("SQLException while retrieving server name", sQLException);
            return "";
        }
    }

    public synchronized Connection changeDatabase(String string) throws SQLException, ClassNotFoundException {
        this.logger.debug("changeDatabase(" + string + ')');
        if (this.isConnected()) {
            this.disconnect();
        }
        ConnectionParametersBuilder connectionParametersBuilder = this.cp.getConnectionParametersBuilder();
        connectionParametersBuilder.setDatabaseName(string);
        this.cp = connectionParametersBuilder.getConnectionParameters();
        this.connect();
        return this.getDBConnection();
    }

    public static String getConnectionErrorInfo() {
        if (errorCode != null && errorMessage != null) {
            return "Error code: " + errorCode.toString() + "\n" + errorMessage;
        }
        return null;
    }

    public static void configureJdbcDrivers() throws ClassNotFoundException {
        JdbcDriversProperty.addValue((int)1, (String)"com.ibm.db2.jcc.DB2Driver");
        Class.forName("com.ibm.db2.jcc.DB2Driver");
    }
}

