/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.informix.connection.listener;

import com.ibm.arcs.database.DatabaseProtocol;
import com.ibm.arcs.database.DatabaseServerName;
import com.ibm.arcs.database.connection.listener.ListenerParameters;
import com.ibm.arcs.host.HostName;
import com.ibm.arcs.host.HostPort;
import com.ibm.arcs.serialization.xml.XmlSerializer;
import com.ibm.arcs.serialization.xml.catalog.HybridXmlSerializerCatalog;
import com.ibm.arcs.serialization.xml.catalog.XmlSerializerCatalog;
import com.ibm.informix.connection.InformixDatabaseServerName;
import com.ibm.informix.connection.listener.InformixServerConnectionType;
import org.eclipse.core.runtime.CoreException;

public final class InformixListenerParameters
implements ListenerParameters {
    private final InformixDatabaseServerName databaseServerName;
    private final InformixServerConnectionType informixServerConnectionType;
    private final HostName hostName;
    private final HostPort hostPort;

    public InformixListenerParameters(InformixDatabaseServerName informixDatabaseServerName, InformixServerConnectionType informixServerConnectionType, HostName hostName, HostPort hostPort) {
        this.databaseServerName = informixDatabaseServerName;
        this.informixServerConnectionType = informixServerConnectionType;
        this.hostName = hostName;
        this.hostPort = hostPort;
    }

    public DatabaseProtocol getDatabaseProtocol() {
        return this.informixServerConnectionType.getDatabaseProtocol();
    }

    public DatabaseServerName getDatabaseServerName() {
        return this.databaseServerName;
    }

    public HostName getHostName() {
        return this.hostName;
    }

    public HostPort getHostPort() {
        return this.hostPort;
    }

    public InformixServerConnectionType getInformixServerConnectionType() {
        return this.informixServerConnectionType;
    }

    public String toString() {
        try {
            HybridXmlSerializerCatalog hybridXmlSerializerCatalog = HybridXmlSerializerCatalog.getSharedInstance();
            XmlSerializer xmlSerializer = hybridXmlSerializerCatalog.getSerializerForClass(InformixListenerParameters.class);
            return xmlSerializer.toHierarchicalParameter((Object)this, (XmlSerializerCatalog)hybridXmlSerializerCatalog).toString();
        }
        catch (CoreException coreException) {
            throw new RuntimeException(coreException.getCause());
        }
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.databaseServerName == null ? 0 : this.databaseServerName.hashCode());
        n = 31 * n + (this.hostName == null ? 0 : this.hostName.hashCode());
        n = 31 * n + (this.hostPort == null ? 0 : this.hostPort.hashCode());
        n = 31 * n + (this.informixServerConnectionType == null ? 0 : this.informixServerConnectionType.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof InformixListenerParameters)) {
            return false;
        }
        InformixListenerParameters informixListenerParameters = (InformixListenerParameters)object;
        if (this.databaseServerName == null ? informixListenerParameters.databaseServerName != null : !this.databaseServerName.equals(informixListenerParameters.databaseServerName)) {
            return false;
        }
        if (this.hostName == null ? informixListenerParameters.hostName != null : !this.hostName.equals((Object)informixListenerParameters.hostName)) {
            return false;
        }
        if (this.hostPort == null ? informixListenerParameters.hostPort != null : !this.hostPort.equals((Object)informixListenerParameters.hostPort)) {
            return false;
        }
        return this.informixServerConnectionType == informixListenerParameters.informixServerConnectionType;
    }
}

