/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.informix.connection.listener;

import com.ibm.arcs.basic.node.Node;
import com.ibm.arcs.basic.node.NodeSearches;
import com.ibm.arcs.basic.node.matcher.NodeMatcher;
import com.ibm.arcs.basic.parameter.hierarchical.HierarchicalParameter;
import com.ibm.arcs.basic.parameter.hierarchical.matcher.HierarchicalParameterMatcher;
import com.ibm.arcs.host.Host;
import com.ibm.arcs.host.HostCatalog;
import com.ibm.arcs.host.HostName;
import com.ibm.arcs.host.HostPort;
import com.ibm.arcs.serialization.xml.AbstractXmlSerializer;
import com.ibm.arcs.serialization.xml.catalog.XmlSerializerCatalog;
import com.ibm.arcs.serialization.xml.serializer.ObjectSerializer;
import com.ibm.informix.connection.InformixDatabaseServerName;
import com.ibm.informix.connection.listener.InformixListenerParameters;
import com.ibm.informix.connection.listener.InformixListenerParametersKeys;
import com.ibm.informix.connection.listener.InformixServerConnectionType;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class InformixListenerParametersXmlSerializer
extends AbstractXmlSerializer {
    public boolean accepts(Class<?> clazz) {
        return clazz.equals(InformixListenerParameters.class);
    }

    public HierarchicalParameter toHierarchicalParameter(Object object, XmlSerializerCatalog xmlSerializerCatalog) {
        Class<?> clazz = object.getClass();
        if (this.accepts(clazz)) {
            InformixListenerParameters informixListenerParameters = (InformixListenerParameters)object;
            HierarchicalParameter hierarchicalParameter = ObjectSerializer.createRootNode(clazz, (XmlSerializerCatalog)xmlSerializerCatalog);
            new HierarchicalParameter(InformixListenerParametersKeys.DbServerName.getKey(), informixListenerParameters.getDatabaseServerName().getName(), hierarchicalParameter);
            new HierarchicalParameter(InformixListenerParametersKeys.DbServerConnectionType.getKey(), informixListenerParameters.getInformixServerConnectionType().name(), hierarchicalParameter);
            new HierarchicalParameter(InformixListenerParametersKeys.HostName.getKey(), informixListenerParameters.getHostName().getName().toString(), hierarchicalParameter);
            new HierarchicalParameter(InformixListenerParametersKeys.HostPort.getKey(), informixListenerParameters.getHostPort().toString(), hierarchicalParameter);
            return hierarchicalParameter;
        }
        throw new IllegalArgumentException("incompatible classes");
    }

    public InformixListenerParameters fromXml(HierarchicalParameter hierarchicalParameter, XmlSerializerCatalog xmlSerializerCatalog) throws CoreException {
        try {
            String string = InformixListenerParametersXmlSerializer.getParameters(InformixListenerParametersKeys.DbServerName.getMatcher(), hierarchicalParameter);
            InformixDatabaseServerName informixDatabaseServerName = new InformixDatabaseServerName(string);
            String string2 = InformixListenerParametersXmlSerializer.getParameters(InformixListenerParametersKeys.DbServerConnectionType.getMatcher(), hierarchicalParameter);
            InformixServerConnectionType informixServerConnectionType = InformixServerConnectionType.valueOf(string2);
            Host host = HostCatalog.getNewHost();
            String string3 = InformixListenerParametersXmlSerializer.getParameters(InformixListenerParametersKeys.HostName.getMatcher(), hierarchicalParameter);
            HostName hostName = host.addHostName(string3);
            String string4 = InformixListenerParametersXmlSerializer.getParameters(InformixListenerParametersKeys.HostPort.getMatcher(), hierarchicalParameter);
            HostPort hostPort = new HostPort(Integer.parseInt(string4));
            return new InformixListenerParameters(informixDatabaseServerName, informixServerConnectionType, hostName, hostPort);
        }
        catch (Exception exception) {
            throw new CoreException((IStatus)new Status(4, "com.ibm.informix.connection", "unable to extract values from hierarchical parameter", (Throwable)exception));
        }
    }

    private static String getParameters(HierarchicalParameterMatcher hierarchicalParameterMatcher, HierarchicalParameter hierarchicalParameter) throws Exception {
        List list = NodeSearches.getAllMatching((Node)hierarchicalParameter, (NodeMatcher)hierarchicalParameterMatcher, (int)1);
        if (list.size() != 1) {
            throw new Exception("can't incorrect number of nodes --- " + hierarchicalParameterMatcher.toString());
        }
        String string = list.toArray(new HierarchicalParameter[list.size()])[0].getValue();
        return string;
    }

    public static final InformixListenerParameters createListenerParameters(HierarchicalParameter hierarchicalParameter) throws Exception {
        if (hierarchicalParameter.getKey() != "com.ibm.arcs.database.ListenerParameters") {
            throw new IllegalArgumentException("not a listener parameter");
        }
        String string = InformixListenerParametersXmlSerializer.getParameters(InformixListenerParametersKeys.DbServerName.getMatcher(), hierarchicalParameter);
        InformixDatabaseServerName informixDatabaseServerName = new InformixDatabaseServerName(string);
        String string2 = InformixListenerParametersXmlSerializer.getParameters(InformixListenerParametersKeys.DbServerConnectionType.getMatcher(), hierarchicalParameter);
        InformixServerConnectionType informixServerConnectionType = InformixServerConnectionType.valueOf(string2);
        Host host = HostCatalog.getNewHost();
        String string3 = InformixListenerParametersXmlSerializer.getParameters(InformixListenerParametersKeys.HostName.getMatcher(), hierarchicalParameter);
        HostName hostName = host.addHostName(string3);
        String string4 = InformixListenerParametersXmlSerializer.getParameters(InformixListenerParametersKeys.HostPort.getMatcher(), hierarchicalParameter);
        HostPort hostPort = new HostPort(Integer.parseInt(string4));
        return new InformixListenerParameters(informixDatabaseServerName, informixServerConnectionType, hostName, hostPort);
    }
}

