/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.informix.connection.listener;

import com.ibm.arcs.database.DatabaseProtocol;
import com.ibm.arcs.database.DatabaseProtocolRegistry;
import com.ibm.informix.connection.listener.InformixServerInterfaceType;
import com.ibm.informix.connection.listener.InformixServerNetworkProtocol;
import com.ibm.informix.connection.listener.InformixServerProduct;
import org.eclipse.core.runtime.CoreException;

public enum InformixServerConnectionType {
    drsocssl(InformixServerProduct.dr, InformixServerInterfaceType.soc, InformixServerNetworkProtocol.ssl),
    drsoctcp(InformixServerProduct.dr, InformixServerInterfaceType.soc, InformixServerNetworkProtocol.tcp),
    drtlitcp(InformixServerProduct.dr, InformixServerInterfaceType.tli, InformixServerNetworkProtocol.tcp),
    onipcshm(InformixServerProduct.on, InformixServerInterfaceType.ipc, InformixServerNetworkProtocol.shm),
    onipcstr(InformixServerProduct.on, InformixServerInterfaceType.ipc, InformixServerNetworkProtocol.str),
    onipcnmp(InformixServerProduct.on, InformixServerInterfaceType.ipc, InformixServerNetworkProtocol.nmp),
    ontlitcp(InformixServerProduct.on, InformixServerInterfaceType.tli, InformixServerNetworkProtocol.tcp),
    onsocssl(InformixServerProduct.on, InformixServerInterfaceType.soc, InformixServerNetworkProtocol.ssl),
    onsoctcp(InformixServerProduct.on, InformixServerInterfaceType.soc, InformixServerNetworkProtocol.tcp),
    ontlispx(InformixServerProduct.on, InformixServerInterfaceType.tli, InformixServerNetworkProtocol.spx),
    onsocimc(InformixServerProduct.on, InformixServerInterfaceType.soc, InformixServerNetworkProtocol.imc),
    ontliimc(InformixServerProduct.on, InformixServerInterfaceType.tli, InformixServerNetworkProtocol.imc),
    onsqlmux(InformixServerProduct.on, InformixServerInterfaceType.sql, InformixServerNetworkProtocol.mux),
    olsoctcp(InformixServerProduct.ol, InformixServerInterfaceType.soc, InformixServerNetworkProtocol.tcp);

    private static final String DRDA_PROTOCOL_ID = "com.ibm.informix.protocol.drda.DrdaProtocol";
    private static final String SQLI_PROTOCOL_ID = "com.ibm.informix.protocol.sqli.SqliProtocol";
    private final InformixServerProduct informixServerProduct;
    private final InformixServerInterfaceType informixServerInterfaceType;
    private final InformixServerNetworkProtocol informixServerNetworkProtocol;

    private InformixServerConnectionType(InformixServerProduct informixServerProduct, InformixServerInterfaceType informixServerInterfaceType, InformixServerNetworkProtocol informixServerNetworkProtocol) {
        this.informixServerProduct = informixServerProduct;
        this.informixServerInterfaceType = informixServerInterfaceType;
        this.informixServerNetworkProtocol = informixServerNetworkProtocol;
    }

    public InformixServerProduct getInformixServerProduct() {
        return this.informixServerProduct;
    }

    public InformixServerInterfaceType getInformixServerInterfaceType() {
        return this.informixServerInterfaceType;
    }

    public InformixServerNetworkProtocol getInformixServerNetworkProtocol() {
        return this.informixServerNetworkProtocol;
    }

    public String toString() {
        return this.name();
    }

    public boolean isNetworkCapable() {
        return this.informixServerInterfaceType.isNetworkCapable();
    }

    public DatabaseProtocol getDatabaseProtocol() {
        try {
            switch (this.getInformixServerProduct()) {
                case dr: {
                    return DatabaseProtocolRegistry.getDatabaseProtocolById((String)DRDA_PROTOCOL_ID);
                }
                case on: 
                case ol: {
                    return DatabaseProtocolRegistry.getDatabaseProtocolById((String)SQLI_PROTOCOL_ID);
                }
            }
            throw new RuntimeException("unknown InformixServerProduct encountered during attempt to map to DatabaseProtocol");
        }
        catch (CoreException coreException) {
            throw new RuntimeException(coreException);
        }
    }
}

