/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.informix.connection.listener;

import com.ibm.arcs.basic.strings.ParameterParse;
import com.ibm.informix.connection.listener.InformixServerAlias;
import java.util.Vector;

public class InformixServerName {
    private String dbServerName = null;
    private Vector<InformixServerAlias> aliases = null;

    public InformixServerName(String string) throws IllegalArgumentException {
        if (!string.matches("[^A-Z\n\t@-]*")) {
            throw new IllegalArgumentException("DBSERVERNAME must be a well formed.\nIt must:\nBegin with a letter and can include any printable character, except the following characters:\n* Uppercase characters\n* A field delimiter (space or tab)\n* A newline character\n* A comment character\n* A hyphen, minus, or @ character");
        }
        this.dbServerName = string;
        this.aliases = new Vector();
    }

    public String getName() {
        return this.dbServerName;
    }

    public Vector<InformixServerAlias> getDbServerAliases() {
        return this.aliases;
    }

    void addDBServerAlias(String string) throws Exception {
        if (this.aliases.size() > 32) {
            throw new Exception("DBSERVERALIASES has to be a list no greater than 32 aliases");
        }
        this.aliases.addElement(new InformixServerAlias(string, this));
    }

    void addDBServerAliases(String string) throws Exception {
        String[] stringArray = null;
        String[] stringArray2 = stringArray = ParameterParse.parseParameters((String)string);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray2[n2];
            this.addDBServerAlias(string2);
            ++n2;
        }
    }

    public String toString() {
        return this.dbServerName;
    }

    public static void main(String[] stringArray) {
        InformixServerName informixServerName = null;
        try {
            informixServerName = new InformixServerName("Localhost");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            informixServerName = new InformixServerName("localhost");
            informixServerName.addDBServerAlias("mymaching");
            informixServerName.addDBServerAlias("my_host");
            informixServerName.addDBServerAliases("myhost,ourhost,mayo,ids0");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        System.out.println(informixServerName.getName());
        for (InformixServerAlias informixServerAlias : informixServerName.getDbServerAliases()) {
            System.out.println(informixServerAlias.getAliasName());
        }
    }
}

