/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.informix.identifier;

import com.ibm.informix.identifier.AbstractInformixIdentifier;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class InformixDelimitedIdentifier
extends AbstractInformixIdentifier {
    private static char[] delimiters = new char[]{'\'', '\"'};

    public InformixDelimitedIdentifier(String string) {
        super(string);
    }

    @Override
    protected IStatus validate(String string) {
        IStatus iStatus = InformixDelimitedIdentifier.validateDelimiter(string);
        if (!iStatus.isOK()) {
            return iStatus;
        }
        String string2 = InformixDelimitedIdentifier.stripDelimiter(string);
        IStatus iStatus2 = this.validateLength(string2);
        if (!iStatus2.isOK()) {
            return iStatus2;
        }
        IStatus iStatus3 = this.validateIdentifer(string2, 1);
        if (!iStatus3.isOK()) {
            return iStatus3;
        }
        return Status.OK_STATUS;
    }

    private static String stripDelimiter(String string) {
        return string.substring(1, string.length() - 1);
    }

    private IStatus validateIdentifer(String string, int n) {
        if (this.hasLeadingSpaces(string)) {
            return new Status(2, "com.ibm.informix.connection", "one or more leading spaces are present");
        }
        return Status.OK_STATUS;
    }

    private boolean hasLeadingSpaces(String string) {
        int n = string.codePointAt(0);
        return Character.isSpaceChar(n);
    }

    public static boolean isDelimited(String string) {
        try {
            InformixDelimitedIdentifier.getDelimiterChar(string);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static IStatus validateDelimiter(String string) {
        try {
            InformixDelimitedIdentifier.getDelimiterChar(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return new Status(4, "com.ibm.informix.connection", "the string " + string + " does not contain a valid delimiter");
        }
        return Status.OK_STATUS;
    }

    public static char getDelimiterChar(String string) {
        if (string.length() == 0) {
            throw new IllegalArgumentException("strings of length zero cannot contain a pair of delimiter characters");
        }
        if (string.length() == 1) {
            throw new IllegalArgumentException("strings of length one cannot contain a pair of delimiter characters");
        }
        char c = InformixDelimitedIdentifier.getFirstChar((String)string);
        if (InformixDelimitedIdentifier.isDelimited(string, c)) {
            return c;
        }
        throw new IllegalArgumentException("string '" + string + "' does not contain a pair of delimiter characters");
    }

    private static boolean isDelimited(String string, char c) {
        if (!InformixDelimitedIdentifier.isValidDelimiter(c)) {
            return false;
        }
        return c == InformixDelimitedIdentifier.getFirstChar((String)string) && c == InformixDelimitedIdentifier.getLastChar((String)string);
    }

    private static boolean isValidDelimiter(char c) {
        int n = 0;
        while (n < delimiters.length) {
            if (c == delimiters[n]) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

