/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.informix.deploy.ui.cli;

import com.ibm.informix.deploy.DeploymentController;
import com.ibm.informix.deploy.job.BundleJob;
import com.ibm.informix.deploy.job.DataSpacesJob;
import com.ibm.informix.deploy.job.DeploymentJob;
import com.ibm.informix.deploy.ui.Messages;
import com.ibm.informix.deploy.ui.Utility;
import com.ibm.informix.deploy.ui.cli.ConfigurationBuilder;
import com.ibm.informix.deploy.ui.cli.Option;
import com.ibm.informix.deploy.ui.cli.Progress;
import com.ibm.informix.deploy.ui.wizard.DeploymentWizard;
import com.ibm.informix.deploy.ui.wizard.DeploymentWizardDialog;
import java.util.HashMap;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class CommandLine {
    public static final int SUCCESS = 0;
    public static final int ERROR = 1;
    public static final int MISSINGARGUMENT = 2;
    public static final int INVALIDOPTION = 3;
    public static final int IMPROPERSYNTAX = 4;
    public static final int MISSINGREQUIRED = 5;
    public static final int UNIMPLEMENTEDOPTION = 6;
    public static int cliCode = 0;
    private static final HashMap<Character, Option> optionsMap = new HashMap(Option.values().length);
    private final String[] parameters;
    private DeploymentController controller;

    static {
        Option[] optionArray = Option.values();
        int n = optionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Option option = optionArray[n2];
            optionsMap.put(Character.valueOf(option.shortcut), option);
            ++n2;
        }
    }

    public CommandLine(String[] stringArray) {
        this.parameters = stringArray;
    }

    public int execute() {
        ConfigurationBuilder configurationBuilder;
        block8: {
            configurationBuilder = null;
            configurationBuilder = new ConfigurationBuilder(this.parameters);
            this.controller = configurationBuilder.getController();
            if (!this.controller.getConfiguration().help) break block8;
            Option.displayHelp();
            return 0;
        }
        try {
            if (this.controller.getConfiguration().version) {
                Option.displayVersion();
                return 0;
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            Option.displayErrorAndUsage(String.valueOf(Messages.CLI_Unimplemented) + " -" + unsupportedOperationException.getMessage());
            return 6;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Option.displayErrorAndUsage(String.valueOf(Messages.CLI_Improper) + " " + illegalArgumentException.getMessage());
            return 4;
        }
        catch (NullPointerException nullPointerException) {
            Option.displayErrorAndUsage(String.valueOf(Messages.CLI_Invalid) + " -" + nullPointerException.getMessage());
            return 3;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            Option.displayErrorAndUsage(String.valueOf(Messages.CLI_MissingArg) + " -" + arrayIndexOutOfBoundsException.getMessage());
            return 2;
        }
        catch (Exception exception) {
            Option.displayError(exception.getMessage());
            return 1;
        }
        return this.controller.getConfiguration().commandLine ? this.executeCLI(configurationBuilder) : this.executeGUI();
    }

    private int executeCLI(ConfigurationBuilder configurationBuilder) {
        try {
            configurationBuilder.connect();
            this.processSnapshotData();
            new Progress(this.controller, Utility.PRINTSTREAM).run();
        }
        catch (IllegalStateException illegalStateException) {
            Option.displayErrorAndUsage(illegalStateException.getMessage());
            cliCode = 5;
        }
        catch (Throwable throwable) {
            Option.displayError(throwable.getMessage());
            cliCode = 1;
        }
        return cliCode;
    }

    private int executeGUI() {
        int n = 0;
        Display display = PlatformUI.createDisplay();
        try {
            DeploymentWizard deploymentWizard = new DeploymentWizard(this.controller);
            DeploymentWizardDialog deploymentWizardDialog = new DeploymentWizardDialog(display.getActiveShell(), (IWizard)deploymentWizard);
            deploymentWizardDialog.create();
            int n2 = deploymentWizardDialog.open();
            return n2;
        }
        catch (Throwable throwable) {
            Option.displayError(throwable.getMessage());
            n = 1;
        }
        finally {
            display.dispose();
        }
        return n;
    }

    private void processSnapshotData() throws Exception {
        if (!this.controller.getConfiguration().isComplete()) {
            throw new IllegalStateException(Messages.CLI_NoRequired);
        }
        if (this.controller.getConfiguration().includeServer) {
            this.controller.addJob((DeploymentJob)new BundleJob(this.controller));
        }
        if (this.controller.getConfiguration().includeData) {
            this.controller.addJob((DeploymentJob)new DataSpacesJob(this.controller));
        }
    }
}

