/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.informix.deploy.ui.cli;

import com.ibm.arcs.database.DatabaseProtocol;
import com.ibm.arcs.database.DatabaseProtocols;
import com.ibm.arcs.database.connection.ConnectionParameters;
import com.ibm.informix.deploy.DeploymentConfiguration;
import com.ibm.informix.deploy.DeploymentController;
import com.ibm.informix.deploy.Utility;
import com.ibm.informix.deploy.archive.Format;
import com.ibm.informix.deploy.ui.Messages;
import com.ibm.informix.deploy.ui.cli.Option;
import com.ibm.informix.protocol.drda.DrdaProtocol;
import java.util.HashMap;

public class ConfigurationBuilder {
    private final DeploymentConfiguration deploymentConfig;
    private final DeploymentController controller;
    private String[] connectionInfo;
    private String[] credentials;
    private DatabaseProtocol dbProtocol = com.ibm.informix.deploy.ui.Utility.DEFAULTDBPROTOCOL;
    private static final HashMap<Character, Option> optionsMap = new HashMap(Option.values().length);

    static {
        Option[] optionArray = Option.values();
        int n = optionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Option option = optionArray[n2];
            optionsMap.put(Character.valueOf(option.shortcut), option);
            ++n2;
        }
    }

    ConfigurationBuilder(String[] stringArray) throws Exception {
        this.deploymentConfig = new DeploymentConfiguration();
        this.controller = new DeploymentController(this.deploymentConfig);
        if (stringArray != null) {
            this.processParameters(stringArray);
        }
    }

    DeploymentController getController() {
        return this.controller;
    }

    private void processParameters(String[] stringArray) throws Exception {
        int n = 0;
        while (n < stringArray.length) {
            char[] cArray = ConfigurationBuilder.getOptions(stringArray[n]);
            int n2 = cArray.length;
            int n3 = 0;
            while (n3 < n2) {
                char c = cArray[n3];
                switch (ConfigurationBuilder.getOption(c)) {
                    case ARCHIVE: {
                        this.readFormat(ConfigurationBuilder.getParameter(stringArray, ++n));
                        break;
                    }
                    case CLI: {
                        this.deploymentConfig.commandLine = true;
                        break;
                    }
                    case DATA: {
                        this.deploymentConfig.includeData = true;
                        break;
                    }
                    case FILENAME: {
                        this.deploymentConfig.setSnapshotFilename(ConfigurationBuilder.getParameter(stringArray, ++n));
                        break;
                    }
                    case HELP: {
                        this.deploymentConfig.help = true;
                        return;
                    }
                    case INSTANCE: {
                        this.readInstance(ConfigurationBuilder.getParameter(stringArray, ++n));
                        break;
                    }
                    case USER: {
                        this.readCredentials(ConfigurationBuilder.getParameter(stringArray, ++n));
                        break;
                    }
                    case NOSERVER: {
                        this.deploymentConfig.includeServer = false;
                        break;
                    }
                    case VERBOSE: {
                        this.deploymentConfig.verbose = true;
                        break;
                    }
                    case REVISION: 
                    case VERSION: {
                        this.deploymentConfig.version = true;
                        return;
                    }
                    default: {
                        throw new UnsupportedOperationException(String.valueOf(c));
                    }
                }
                ++n3;
            }
            ++n;
        }
    }

    private void readInstance(String string) throws Exception {
        String[] stringArray = string.split(":");
        if (stringArray.length == 4) {
            this.dbProtocol = DatabaseProtocols.getDatabaseProtocol((String)stringArray[3]);
        } else if (stringArray.length != 3) {
            throw new IllegalArgumentException(string);
        }
        this.connectionInfo = stringArray;
    }

    private void readCredentials(String string) throws Exception {
        String[] stringArray = string.split(":");
        if (stringArray.length != 2) {
            throw new IllegalArgumentException("Invalid username/password format");
        }
        this.credentials = stringArray;
    }

    private void readFormat(String string) {
        this.deploymentConfig.setArchiveFormat(Format.valueOf((String)string.toUpperCase()));
    }

    public void connect() throws Exception {
        ConnectionParameters connectionParameters = null;
        if (this.connectionInfo == null) {
            connectionParameters = this.credentials == null ? Utility.getConnectionFromEnvironment() : Utility.getConnectionFromEnvironment((String)this.credentials[0], (String)this.credentials[1]);
        } else if (this.credentials == null) {
            if (this.dbProtocol instanceof DrdaProtocol) {
                throw new IllegalStateException("Username and password (-" + Option.USER.shortcut + ") must be specified when using the DRDA protocol");
            }
            connectionParameters = Utility.getConnectionParameters((String)this.connectionInfo[0], (String)this.connectionInfo[1], (String)this.connectionInfo[2], (DatabaseProtocol)this.dbProtocol);
        } else {
            connectionParameters = Utility.getConnectionParameters((String)this.connectionInfo[0], (String)this.connectionInfo[1], (String)this.connectionInfo[2], (DatabaseProtocol)this.dbProtocol, (String)this.credentials[0], (String)this.credentials[1]);
        }
        try {
            this.controller.setConnection(connectionParameters);
        }
        catch (Exception exception) {
            throw new IllegalStateException(Messages.CLI_NoConnection, exception.getCause());
        }
    }

    private static char[] getOptions(String string) throws Exception {
        if (string.length() < 2 || string.charAt(0) != '-') {
            throw new IllegalArgumentException(string);
        }
        switch (string.charAt(1)) {
            case '-': {
                return new char[]{Option.getOption((String)string.substring((int)2)).shortcut};
            }
        }
        return string.substring(1).toCharArray();
    }

    private static String getParameter(String[] stringArray, int n) {
        if (n < stringArray.length) {
            return stringArray[n];
        }
        throw new ArrayIndexOutOfBoundsException(stringArray[stringArray.length - 1]);
    }

    private static Option getOption(char c) {
        Option option = optionsMap.get(Character.valueOf(c));
        if (option == null) {
            throw new NullPointerException(String.valueOf(c));
        }
        return option;
    }
}

