/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.informix.deploy.ui.cli;

import com.ibm.informix.deploy.ui.Messages;
import com.ibm.informix.deploy.ui.Utility;
import com.ibm.informix.deploy.ui.Version;
import org.eclipse.osgi.util.NLS;

public enum Option {
    ARCHIVE("archive", 'a', Messages.Option_Format, true, Option.getArchiveDescription()),
    CLI("command-line", 'c', true, Messages.Option_CLIDescription),
    DATA("data", 'd', true, Messages.Option_DataDescription),
    FILENAME("filename", 'f', Messages.Option_Path, true, Option.getFilenameDescription()),
    HELP("help", 'h', true, Messages.Option_HelpDescription),
    INSTANCE("instance", 'i', Messages.Option_ConnectionInfo, true, Option.getInstanceDescription()),
    USER("user", 'u', "credentials", true, Option.getUserDescription()),
    NOSERVER("no-server", 'n', true, Option.getNoServerDescription()),
    VERBOSE("verbose", 'v', true, Messages.Option_VerboseDescription),
    REVISION("revision", 'r', true, Messages.Option_VersionDescription),
    VERSION("version", Option.REVISION.shortcut, Option.REVISION.optional, Option.REVISION.description);

    public final String name;
    public final char shortcut;
    public final boolean optional;
    public final String argument;
    public final String[] description;

    private Option(String string2, char c, boolean bl, String ... stringArray) {
        this(string2, c, null, bl, stringArray);
    }

    private Option(String string2, char c, String string3, boolean bl, String ... stringArray) {
        this.name = string2;
        this.shortcut = c;
        this.argument = string3;
        this.optional = bl;
        this.description = stringArray;
    }

    public static Option getOption(String string) {
        Option[] optionArray = Option.values();
        int n = optionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Option option = optionArray[n2];
            if (option.name.equalsIgnoreCase(string)) {
                return option;
            }
            ++n2;
        }
        return null;
    }

    static void displaySyntax() {
        StringBuilder stringBuilder = new StringBuilder("ifxdeployassist [");
        StringBuilder stringBuilder2 = new StringBuilder();
        Option[] optionArray = Option.values();
        int n = optionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Option option = optionArray[n2];
            if (option != Option.values()[0]) {
                stringBuilder.append(" ");
            }
            if (option.optional) {
                stringBuilder.append("[");
            }
            stringBuilder.append("-" + option.shortcut);
            stringBuilder.append(Option.getFormattedVariable(option.argument));
            if (option.optional) {
                stringBuilder.append("]");
            }
            stringBuilder2.append("   -" + option.shortcut + ", --" + option.name + Option.getFormattedVariable(option.argument));
            stringBuilder2.append(Messages.NEW_LINE);
            String[] stringArray = option.description;
            int n3 = option.description.length;
            int n4 = 0;
            while (n4 < n3) {
                String string = stringArray[n4];
                stringBuilder2.append("        " + string);
                stringBuilder2.append(Messages.NEW_LINE);
                ++n4;
            }
            stringBuilder2.append(Messages.NEW_LINE);
            ++n2;
        }
        stringBuilder.append("]");
        Utility.PRINTSTREAM.print(stringBuilder2.toString());
    }

    static String getFormattedVariable(String string) {
        if (string == null) {
            return "";
        }
        return " <" + string + ">";
    }

    static void displayVersion() {
        Utility.PRINTSTREAM.println("Program Name:     ifxdeployassist");
        Utility.PRINTSTREAM.println("Build Version:    " + Version.BuildVersion);
        Utility.PRINTSTREAM.println("Build ID:         " + Version.BuildId);
        Utility.PRINTSTREAM.println("Build Host:       " + Version.BuildHost);
        Utility.PRINTSTREAM.println("Build OS:         " + Version.BuildOS);
        Utility.PRINTSTREAM.println("Build Date:       " + Version.BuildDate);
        Utility.PRINTSTREAM.println("Eclipse Version:  " + Version.BuildEclipse);
        Utility.PRINTSTREAM.println("Java Version:     " + Version.BuildJava);
    }

    static void displayHelp() {
        Utility.PRINTSTREAM.println(Messages.Option_UsageDescription);
        Utility.PRINTSTREAM.println();
        Option.displayUsage();
    }

    static void displayUsage() {
        Utility.PRINTSTREAM.print(String.valueOf(Messages.Option_Usage) + ": " + "ifxdeployassist" + " ");
        Utility.PRINTSTREAM.println(" [-cdhnrv] [-a <" + Messages.Option_Format + ">] [-f <" + Messages.Option_Path + ">] [-i <" + Messages.Option_ConnectionInfo + ">] [-u <" + Option.USER.argument + ">]");
        Utility.PRINTSTREAM.println();
        Option.displaySyntax();
        Utility.PRINTSTREAM.println(NLS.bind((String)Messages.Option_Additional, (Object)"ifxdeployassist"));
        Utility.PRINTSTREAM.println();
    }

    static void displayError(String string) {
        Utility.PRINTSTREAM.println("ifxdeployassist: " + string);
    }

    static void displayErrorAndUsage(String string) {
        Option.displayError(string);
        Option.displayUsage();
    }

    private static String[] getFilenameDescription() {
        return new String[]{Messages.Option_FilenameDescription, NLS.bind((String)Messages.Option_FilenameDescription1, (Object)("-" + Option.ARCHIVE.shortcut)), Messages.Option_FilenameDescription2, "  " + Messages.Option_FilenameDescription3};
    }

    private static String[] getInstanceDescription() {
        return new String[]{Messages.Option_InstanceDescription, String.valueOf(Messages.Option_InstanceDescription2) + " <" + Messages.Option_Instance + ">:<" + Messages.Option_Host + ">:<" + Messages.Option_Port + ">[:SQLI|DRDA]", Option.getInstanceArgDescription(Messages.Option_Instance, Messages.Option_ServerNameDescription), Option.getInstanceArgDescription(Messages.Option_Host, Messages.Option_HostDescription), Option.getInstanceArgDescription(Messages.Option_Port, Messages.Option_PortDescription), String.format("  %1$-15s%2$-25s", "SQLI|DRDA", NLS.bind((String)Messages.Option_ProtocolDescription, (Object)"SQLI")), Messages.Option_InstanceDescription3};
    }

    private static String getInstanceArgDescription(Object object, Object object2) {
        return String.format(" %1$-16s%2$-25s", Option.getFormattedVariable((String)object), object2);
    }

    private static String[] getArchiveDescription() {
        return new String[]{Messages.Option_ArchiveDescription, "  BZIP2   " + Messages.Option_BZip2Description, "  GZIP    " + Messages.Option_GZipDescription, "  TAR     " + Messages.Option_TarDescription, "  ZIP     " + Messages.Option_ZipDescription, Messages.Option_ArchiveDescription2};
    }

    private static String[] getNoServerDescription() {
        return new String[]{Messages.Option_NoServerDescription, NLS.bind((String)Messages.Option_NoServerDescription2, (Object)"-n", (Object)("-" + Option.DATA.shortcut))};
    }

    private static String[] getUserDescription() {
        return new String[]{"Specify the username and password to connect with.", String.valueOf(Messages.Option_InstanceDescription2) + " <username>:<password>", "  <username>   A valid username that is recognized by the Informix instance.", "  <password>   The password corresponding to <username>.", "If the DRDA protocol is specified in the -" + Option.INSTANCE.shortcut + " option, then this is required."};
    }
}

