/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.informix.deploy.ui.cli;

import com.ibm.informix.configuration.EnvironmentVariable;
import com.ibm.informix.configuration.InformixInstance;
import com.ibm.informix.deploy.DeploymentController;
import com.ibm.informix.deploy.IProgressListener;
import com.ibm.informix.deploy.ProgressPublisher;
import com.ibm.informix.deploy.job.DeploymentJob;
import com.ibm.informix.deploy.ui.Messages;
import com.ibm.informix.deploy.ui.cli.CommandLine;
import com.ibm.informix.deploy.ui.cli.ProgressCLI;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;

public class Progress
implements IProgressListener {
    private static final String TAB = "   ";
    private final DeploymentController controller;
    private Iterator<DeploymentJob> jobsIterator;
    private final PrintStream printStream;

    public Progress(DeploymentController deploymentController, PrintStream printStream) {
        this.controller = deploymentController;
        this.printStream = printStream;
    }

    public void run() throws Exception {
        if (!this.controller.getConfiguration().isComplete()) {
            this.fireError(new IllegalArgumentException(com.ibm.informix.deploy.Messages.Packager_ErrorSnapshotDataNotProvided));
        }
        boolean bl = this.controller.getConfiguration().verbose;
        List list = this.controller.getJobs();
        if (!list.isEmpty()) {
            if (bl) {
                this.displayTemplateInstanceInfo(this.controller.getConfiguration().getTemplateInstance());
                this.printStream.println();
                this.printStream.println(Messages.Progress_Title);
                this.printStream.println(Messages.Progress_Description);
            }
            for (DeploymentJob deploymentJob : list) {
                if (bl) {
                    new ProgressCLI(deploymentJob, this.printStream);
                }
                if (!(deploymentJob instanceof ProgressPublisher)) continue;
                ((ProgressPublisher)deploymentJob).registerListener((IProgressListener)this);
            }
        }
        this.jobsIterator = this.controller.getJobs().iterator();
        this.nextJob();
    }

    private void displayTemplateInstanceInfo(InformixInstance informixInstance) {
        this.printStream.println();
        this.printStream.print(String.valueOf(EnvironmentVariable.INFORMIXSERVER.getDisplayName()) + ":  ");
        this.printStream.println(TAB + informixInstance.getDatabaseServerName() + " (" + informixInstance.getInformixVersion().getVersionString() + ")");
        this.printStream.print(String.valueOf(EnvironmentVariable.INFORMIXDIR.getDisplayName()) + ":     ");
        this.printStream.println(TAB + informixInstance.getInformixDir());
    }

    private void nextJob() {
        if (this.jobsIterator.hasNext()) {
            if (this.controller.getConfiguration().verbose) {
                this.printStream.println();
            }
            this.jobsIterator.next().run();
        } else if (this.controller.getConfiguration().verbose) {
            this.finish();
        }
    }

    private void finish() {
        this.printStream.println();
        this.printStream.println(Messages.Summary_success);
        this.printStream.println();
        this.printStream.println(Messages.Summary_snapshotsLocation.toUpperCase());
        this.printStream.println(String.valueOf(Messages.Summary_serverLocation) + ":");
        this.printStream.println(TAB + Messages.getServerSummary(this.controller.getConfiguration()));
        this.printStream.println(String.valueOf(Messages.Summary_spacesLocation) + ":");
        this.printStream.println(TAB + Messages.getSpacesSummary(this.controller.getConfiguration()));
    }

    public void fireStart() {
    }

    public void fireUpdate(String string) {
    }

    public void fireUpdate(double d) {
    }

    public void fireComplete() {
        this.nextJob();
    }

    public void fireError(Throwable throwable) {
        CommandLine.cliCode = 1;
        this.printStream.println(String.valueOf(Messages.Progress_error) + ": " + throwable.getMessage());
    }
}

