/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.informix.deploy.ui.cli;

import com.ibm.informix.deploy.IProgressListener;
import com.ibm.informix.deploy.ProgressPublisher;
import com.ibm.informix.deploy.job.DeploymentJob;
import java.io.PrintStream;

public class ProgressCLI
implements IProgressListener {
    private static final int FACTOR = 5;
    private final DeploymentJob deploymentJob;
    private final PrintStream printStream;
    private int percent;

    public ProgressCLI(DeploymentJob deploymentJob, PrintStream printStream) {
        this.deploymentJob = deploymentJob;
        this.printStream = printStream;
        if (deploymentJob instanceof ProgressPublisher) {
            ((ProgressPublisher)deploymentJob).registerListener((IProgressListener)this);
        }
    }

    public void fireStart() {
        this.printStream.println(this.deploymentJob.getName());
        this.printStream.print("[                     ]");
        this.printStream.print("\r[");
    }

    public void fireUpdate(double d) {
        if (d - (double)this.percent >= 5.0) {
            int n = ((int)d - this.percent) / 5;
            int n2 = 0;
            while (n2 < n) {
                this.percent += 5;
                this.printStream.print("|");
                ++n2;
            }
        }
    }

    public void fireUpdate(String string) {
    }

    public void fireComplete() {
        this.printStream.println("|] (Finished)");
    }

    public void fireError(Throwable throwable) {
        this.printStream.println("X");
    }
}

