/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.informix.deploy.ui.wizard;

import com.ibm.arcs.database.connection.ConnectionParameters;
import com.ibm.informix.deploy.DeploymentController;
import com.ibm.informix.deploy.Utility;
import com.ibm.informix.deploy.ui.Messages;
import com.ibm.informix.deploy.ui.wizard.bundle.BundleWizardPage;
import com.ibm.informix.deploy.ui.wizard.config.ConfigurationWizardPage;
import com.ibm.informix.deploy.ui.wizard.connect.ConnectionParametersWizardPage;
import com.ibm.informix.deploy.ui.wizard.detect.AutoDetectInstanceWizardPage;
import com.ibm.informix.deploy.ui.wizard.location.SnapshotLocationWizardPage;
import com.ibm.informix.deploy.ui.wizard.progress.ProgressWizardPage;
import com.ibm.informix.deploy.ui.wizard.spaces.SpacesWizardPage;
import com.ibm.informix.deploy.ui.wizard.summary.SummaryWizardPage;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.MessageBox;

public class DeploymentWizard
extends Wizard {
    private final DeploymentController controller;
    boolean canClose = false;
    AutoDetectInstanceWizardPage autoDetectIDSPage;
    ConnectionParametersWizardPage connectionParametersPage;
    public SnapshotLocationWizardPage packageLocationPage;
    BundleWizardPage bundlePage;
    SpacesWizardPage dataSpacesPage;
    ConfigurationWizardPage configurationPage;
    ProgressWizardPage progressPage;
    public SummaryWizardPage summaryPage;

    public DeploymentWizard(DeploymentController deploymentController) {
        this.controller = deploymentController;
    }

    public void addPages() {
        this.setWindowTitle(Messages.Wizard_AppTitle);
        try {
            ConnectionParameters connectionParameters = Utility.getConnectionFromEnvironment();
            this.controller.setConnection(connectionParameters);
            this.autoDetectIDSPage = new AutoDetectInstanceWizardPage();
            this.addPage((IWizardPage)this.autoDetectIDSPage);
        }
        catch (Throwable throwable) {}
        this.connectionParametersPage = new ConnectionParametersWizardPage();
        this.addPage((IWizardPage)this.connectionParametersPage);
        this.packageLocationPage = new SnapshotLocationWizardPage();
        this.addPage((IWizardPage)this.packageLocationPage);
        this.bundlePage = new BundleWizardPage();
        this.addPage((IWizardPage)this.bundlePage);
        this.dataSpacesPage = new SpacesWizardPage();
        this.addPage((IWizardPage)this.dataSpacesPage);
        this.configurationPage = new ConfigurationWizardPage();
        this.addPage((IWizardPage)this.configurationPage);
        this.progressPage = new ProgressWizardPage();
        this.addPage((IWizardPage)this.progressPage);
        this.summaryPage = new SummaryWizardPage();
        this.addPage((IWizardPage)this.summaryPage);
    }

    public boolean performFinish() {
        return true;
    }

    public boolean canFinish() {
        return this.canClose;
    }

    public boolean performCancel() {
        if (this.canFinish()) {
            return this.performFinish();
        }
        MessageBox messageBox = new MessageBox(this.getShell(), 196);
        messageBox.setMessage(Messages.Wizard_CancelQuestion);
        messageBox.setText(Messages.Wizard_CancelTitle);
        return messageBox.open() == 64;
    }

    public DeploymentController getController() {
        return this.controller;
    }
}

