/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.informix.deploy.ui.wizard;

import com.ibm.informix.configuration.InformixInstance;
import com.ibm.informix.configuration.InformixServer;
import com.ibm.informix.deploy.DeploymentController;
import com.ibm.informix.deploy.ui.Messages;
import com.ibm.informix.deploy.ui.wizard.DeploymentWizard;
import com.ibm.informix.deploy.ui.wizard.TemplateInstanceComposite;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ExpandAdapter;
import org.eclipse.swt.events.ExpandEvent;
import org.eclipse.swt.events.ExpandListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.Layout;

public abstract class DeploymentWizardPage
extends WizardPage {
    private Composite container;
    private TemplateInstanceComposite templateInstanceComposite;
    private ExpandItem templateItem;

    protected DeploymentWizardPage(String string, String string2, ImageDescriptor imageDescriptor) {
        super(string, string2, imageDescriptor);
    }

    protected DeploymentController getController() {
        return ((DeploymentWizard)this.getWizard()).getController();
    }

    public final void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout());
        composite2.setLayoutData((Object)new GridData(4, 128, true, true, 1, 1));
        this.setControl((Control)composite2);
        this.createHeader(composite2);
        this.container = new Composite(composite2, 0);
        this.container.setLayout((Layout)new FillLayout(512));
        this.container.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.createContent(this.container);
    }

    protected void createHeader(Composite composite) {
        ExpandBar expandBar = this.getExpandBar(composite);
        this.templateInstanceComposite = new TemplateInstanceComposite((Composite)expandBar, 2048);
        this.templateItem = new ExpandItem(expandBar, 0, 0);
        this.templateItem.setText(Messages.WizardPage_TemplateTitle);
        this.templateItem.setHeight(this.templateInstanceComposite.computeSize((int)-1, (int)-1).y);
        this.templateItem.setControl((Control)this.templateInstanceComposite);
        this.setHeaderExpanded(false);
    }

    private ExpandBar getExpandBar(Composite composite) {
        final ExpandBar expandBar = new ExpandBar(composite, 512);
        expandBar.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        expandBar.addExpandListener((ExpandListener)new ExpandAdapter(){

            public void itemCollapsed(ExpandEvent expandEvent) {
                this.layout();
            }

            public void itemExpanded(ExpandEvent expandEvent) {
                this.layout();
            }

            private void layout() {
                Display.getCurrent().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        expandBar.getParent().layout();
                    }
                });
            }
        });
        return expandBar;
    }

    protected void setHeaderExpanded(boolean bl) {
        if (this.templateItem != null) {
            this.templateItem.setExpanded(bl);
        }
    }

    public void onEnterPage() {
        if (this.templateInstanceComposite != null) {
            InformixInstance informixInstance = this.getController().getConfiguration().getTemplateInstance();
            this.templateInstanceComposite.update((InformixServer)informixInstance);
            this.templateItem.setText(String.valueOf(Messages.WizardPage_TemplateTitle) + " - " + informixInstance.getDatabaseServerName().getName());
        }
    }

    protected abstract void createContent(Composite var1);
}

