/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.informix.deploy.ui.wizard;

import com.ibm.informix.configuration.EnvironmentVariable;
import com.ibm.informix.configuration.InformixServer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class TemplateInstanceComposite
extends Composite {
    private final Label serverLabel;
    private final Label informixDirLabel;
    private Label instanceLabel;

    public TemplateInstanceComposite(Composite composite, int n) {
        this(composite, n, null);
    }

    public TemplateInstanceComposite(Composite composite, int n, String string) {
        super(composite, n);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.horizontalSpacing = 30;
        gridLayout.verticalSpacing = 10;
        this.setLayout((Layout)gridLayout);
        if (string != null) {
            this.instanceLabel = new Label((Composite)this, 0);
            this.instanceLabel.setText(string);
            this.instanceLabel.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
        }
        Label label = new Label((Composite)this, 131072);
        label.setText(EnvironmentVariable.INFORMIXSERVER.getDisplayName());
        label.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        this.serverLabel = new Label((Composite)this, 16448);
        this.serverLabel.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        Label label2 = new Label((Composite)this, 131072);
        label2.setText(EnvironmentVariable.INFORMIXDIR.getDisplayName());
        label2.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        this.informixDirLabel = new Label((Composite)this, 16448);
        this.informixDirLabel.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        if (string != null) {
            Color color = this.getDisplay().getSystemColor(1);
            this.setBackground(color);
            label.setBackground(color);
            this.serverLabel.setBackground(color);
            label2.setBackground(color);
            this.informixDirLabel.setBackground(color);
            this.instanceLabel.setBackground(color);
        }
    }

    public void update(InformixServer informixServer) {
        this.serverLabel.setText(informixServer.getDatabaseServerName() + "  (" + informixServer.getInformixVersion().getVersionString() + ")");
        this.informixDirLabel.setText(informixServer.getInformixDir());
    }
}

