/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.informix.deploy.ui.wizard.bundle;

import com.ibm.arcs.status.publish.IStatusPublisher;
import com.ibm.arcs.status.ui.group.GroupStatusPublishingComposite;
import com.ibm.informix.bundle.Bundle;
import com.ibm.informix.bundle.InstallType;
import com.ibm.informix.bundle.InstalledBundle;
import com.ibm.informix.bundle.ui.BundleTree;
import com.ibm.informix.bundle.ui.Dependency;
import com.ibm.informix.bundle.ui.SizeColumn;
import com.ibm.informix.bundle.ui.TypeColumn;
import com.ibm.informix.configuration.InformixInstance;
import com.ibm.informix.deploy.ui.Messages;
import com.ibm.informix.deploy.ui.wizard.bundle.BundleDescriptionText;
import com.ibm.informix.deploy.ui.wizard.bundle.BundleTotalLabel;
import com.ibm.informix.deploy.ui.wizard.bundle.InstallTypeCombo;
import java.util.HashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class BundleComposite
extends GroupStatusPublishingComposite {
    private InformixInstance informixInstance;
    private final BundleTree bundleTree;
    private SizeColumn sizeColumn;
    public final Button instanceButton;
    private final InstallTypeCombo installCombo;
    private final BundleDescriptionText descriptionText;
    private final BundleTotalLabel totalLabel;
    private final Dependency dependency;
    private final HashSet<Control> bundleSet = new HashSet();

    public BundleComposite(Composite composite, int n) {
        super(composite, n);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.verticalSpacing = 10;
        this.setLayout((Layout)gridLayout);
        this.instanceButton = BundleComposite.getInstanceButton(this);
        Composite composite2 = BundleComposite.createInstructInstall(this);
        this.bundleTree = this.getBundleTree(this);
        this.installCombo = BundleComposite.getInstallTypeCombo(this.bundleTree, composite2);
        this.dependency = new Dependency(this.bundleTree, 0);
        this.totalLabel = this.getTotal(this);
        this.descriptionText = this.getDescription(this.bundleTree, (Composite)this);
        this.bundleSet.add((Control)this.installCombo);
        this.bundleSet.add((Control)this.bundleTree);
        this.bundleSet.add((Control)this.descriptionText);
        this.bundleSet.add((Control)this.totalLabel);
    }

    private static Button getInstanceButton(BundleComposite bundleComposite) {
        final Button button = new Button((Composite)bundleComposite, 32);
        button.setText("Package a snapshot of the instance");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                BundleComposite.this.setInstanceEnabled(button.getSelection());
            }
        });
        return button;
    }

    private static Composite createInstructInstall(BundleComposite bundleComposite) {
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.horizontalSpacing = 20;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        Composite composite = new Composite((Composite)bundleComposite, 0);
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        Label label = BundleComposite.createInstructionLabel(composite);
        bundleComposite.bundleSet.add((Control)label);
        return composite;
    }

    private static InstallTypeCombo getInstallTypeCombo(BundleTree bundleTree, Composite composite) {
        GridLayout gridLayout = new GridLayout(2, false);
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        Label label = new Label(composite2, 0);
        label.setText(com.ibm.informix.bundle.ui.Messages.BundleTree_Configuration);
        InstallTypeCombo installTypeCombo = new InstallTypeCombo(bundleTree, composite2, 8);
        installTypeCombo.addFull();
        try {
            for (InstallType installType : InstallType.getInstallTypes()) {
                installTypeCombo.add(installType);
            }
        }
        catch (Exception exception) {}
        installTypeCombo.addCustom();
        return installTypeCombo;
    }

    private static Label createInstructionLabel(Composite composite) {
        Label label = new Label(composite, 64);
        label.setText(Messages.InstanceBundle_Instruction);
        label.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        return label;
    }

    private BundleTree getBundleTree(BundleComposite bundleComposite) {
        BundleTree bundleTree = new BundleTree((Composite)bundleComposite, 67584, true);
        bundleTree.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        new TypeColumn(bundleTree);
        this.sizeColumn = new SizeColumn(bundleTree);
        return bundleTree;
    }

    private BundleTotalLabel getTotal(BundleComposite bundleComposite) {
        Composite composite = new Composite((Composite)bundleComposite, 0);
        composite.setLayoutData((Object)new GridData(0x1000008, 4, true, false, 1, 1));
        RowLayout rowLayout = new RowLayout(256);
        rowLayout.spacing = 10;
        composite.setLayout((Layout)rowLayout);
        Label label = new Label(composite, 0);
        label.setText("Approximate Installation Size: ");
        bundleComposite.bundleSet.add((Control)label);
        return new BundleTotalLabel(this.sizeColumn, composite, 0);
    }

    private BundleDescriptionText getDescription(BundleTree bundleTree, Composite composite) {
        Group group = new Group(composite, 0);
        group.setText(Messages.Label_Description);
        group.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        group.setLayout((Layout)new FillLayout());
        BundleDescriptionText bundleDescriptionText = new BundleDescriptionText(bundleTree, (Composite)group, 66);
        bundleDescriptionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                BundleComposite.this.layout();
            }
        });
        return bundleDescriptionText;
    }

    public void setInstanceEnabled(boolean bl) {
        for (Control control : this.bundleSet) {
            control.setEnabled(bl);
        }
        if (bl) {
            this.addStatusPublisher((IStatusPublisher)this.dependency);
            this.dependency.publishStatus(this.dependency.getStatus());
        } else {
            this.removeStatusPublisher((IStatusPublisher)this.dependency);
            for (Control control : this.getStatusListeners()) {
                control.handleStatusUpdate(Status.OK_STATUS);
            }
        }
    }

    public void populate(final InformixInstance informixInstance) {
        if (informixInstance.equals(this.informixInstance)) {
            return;
        }
        this.informixInstance = informixInstance;
        this.setInstanceEnabled(false);
        this.bundleTree.unload();
        this.totalLabel.setText("Calculating...");
        this.layout();
        Job job = new Job("Load Bundle Tree"){

            protected IStatus run(IProgressMonitor iProgressMonitor) {
                iProgressMonitor.beginTask("Load Bundle Tree", -1);
                try {
                    final InstalledBundle installedBundle = new InstalledBundle(informixInstance);
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            try {
                                BundleComposite.this.bundleTree.populate((Bundle)installedBundle);
                                BundleComposite.this.bundleTree.checkAll();
                                BundleComposite.this.installCombo.select(0);
                                BundleComposite.this.setInstanceEnabled((this).BundleComposite.this.instanceButton.getSelection());
                            }
                            catch (Exception exception) {}
                        }
                    };
                    BundleComposite.this.getDisplay().asyncExec(runnable);
                }
                catch (Exception exception) {}
                iProgressMonitor.done();
                return Status.OK_STATUS;
            }
        };
        job.setPriority(10);
        job.setSystem(true);
        job.schedule();
    }

    public BundleTree getBundleTree() {
        return this.bundleTree;
    }
}

