/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.informix.deploy.ui.wizard.bundle;

import com.ibm.informix.bundle.FeatureMember;
import com.ibm.informix.bundle.ui.BundleTree;
import com.ibm.informix.deploy.DeploymentController;
import com.ibm.informix.deploy.archive.FileBundle;
import com.ibm.informix.deploy.job.BundleJob;
import com.ibm.informix.deploy.ui.wizard.bundle.BundleComposite;
import com.ibm.informix.deploy.ui.wizard.bundle.BundleConfigComposite;
import com.ibm.informix.deploy.ui.wizard.config.ConfigurationProvider;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TreeItem;

public class BundleUIJob
extends BundleJob
implements ConfigurationProvider {
    private final BundleComposite bundleComposite;

    public BundleUIJob(DeploymentController deploymentController, BundleComposite bundleComposite) {
        super(deploymentController);
        this.bundleComposite = bundleComposite;
    }

    public void run() {
        this.publishUpdate("Gathering the list of files");
        String string = this.controller.getConfiguration().getTemplateInstance().getInformixDir();
        if (!string.endsWith(File.separator)) {
            string = String.valueOf(string) + File.separator;
        }
        final FileBundle fileBundle = new FileBundle(string, "", "", "");
        this.bundleComposite.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                BundleUIJob.fillBundle(fileBundle, BundleUIJob.this.bundleComposite.getBundleTree());
                BundleUIJob.this.setServerBundle(fileBundle);
            }
        });
        super.run();
    }

    @Override
    public void createConfiguration(Composite composite) {
        new BundleConfigComposite(this.bundleComposite, composite, 0);
    }

    public static void fillBundle(FileBundle fileBundle, BundleTree bundleTree) {
        ArrayList<String> arrayList = new ArrayList<String>();
        BundleUIJob.fillBundle(fileBundle, bundleTree.getTree().getItems(), arrayList);
    }

    private static void fillBundle(FileBundle fileBundle, TreeItem[] treeItemArray, List<String> list) {
        TreeItem[] treeItemArray2 = treeItemArray;
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            block3: {
                TreeItem treeItem;
                block5: {
                    block4: {
                        treeItem = treeItemArray2[n2];
                        if (!treeItem.getChecked() && !treeItem.getGrayed()) break block3;
                        if (treeItem.getItems().length <= 0) break block4;
                        BundleUIJob.fillBundle(fileBundle, treeItem.getItems(), list);
                        break block3;
                    }
                    if (!(treeItem.getData() instanceof FeatureMember)) break block3;
                    if (((FeatureMember)treeItem.getData()).getParents().size() <= 1) break block5;
                    if (list.contains(treeItem.getText())) break block3;
                    list.add(treeItem.getText());
                }
                fileBundle.addFile(treeItem.getText());
            }
            ++n2;
        }
    }
}

