/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.informix.deploy.ui.wizard.bundle;

import com.ibm.arcs.status.listener.IStatusListener;
import com.ibm.informix.deploy.job.DeploymentJob;
import com.ibm.informix.deploy.ui.Messages;
import com.ibm.informix.deploy.ui.wizard.DeploymentWizardPage;
import com.ibm.informix.deploy.ui.wizard.bundle.BundleComposite;
import com.ibm.informix.deploy.ui.wizard.bundle.BundleUIJob;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

public class BundleWizardPage
extends DeploymentWizardPage
implements IStatusListener {
    private BundleComposite bundleComposite;
    private BundleUIJob bundleJob;

    public BundleWizardPage() {
        super("BundleTree", Messages.InstanceBundle_Title, null);
        this.setDescription(Messages.InstanceBundle_Description);
    }

    @Override
    protected void createContent(Composite composite) {
        this.bundleComposite = new BundleComposite(composite, 0);
        this.bundleComposite.addStatusListener(this);
        this.bundleJob = new BundleUIJob(this.getController(), this.bundleComposite);
        this.bundleComposite.instanceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                BundleWizardPage.this.job(((Button)selectionEvent.widget).getSelection());
            }
        });
        boolean bl = this.getController().getConfiguration().includeServer;
        this.bundleComposite.instanceButton.setSelection(bl);
        this.bundleComposite.setInstanceEnabled(bl);
        this.job(bl);
    }

    private void job(boolean bl) {
        this.getController().getConfiguration().includeServer = bl;
        if (bl) {
            this.getController().addJob((DeploymentJob)this.bundleJob);
        } else {
            this.getController().removeJob((DeploymentJob)this.bundleJob);
        }
    }

    public void beforeEnterPage() {
        this.bundleComposite.populate(this.getController().getConfiguration().getTemplateInstance());
    }

    BundleComposite getBundleComposite() {
        return this.bundleComposite;
    }

    public boolean canFlipToNextPage() {
        return this.bundleComposite.getStatus().getSeverity() != 4;
    }

    public void handleStatusUpdate(IStatus iStatus) {
        IStatus iStatus2 = this.bundleComposite.getStatus();
        if (iStatus2 != null) {
            this.applyToStatusLine(iStatus2);
        } else {
            this.setErrorMessage(null);
            this.setMessage(null);
        }
        try {
            this.getContainer().updateButtons();
        }
        catch (Exception exception) {}
    }

    private void applyToStatusLine(IStatus iStatus) {
        String string = iStatus.getMessage();
        if (string.length() == 0) {
            string = null;
        }
        switch (iStatus.getSeverity()) {
            case 0: {
                this.setErrorMessage(null);
                this.setMessage(Messages.InstanceBundle_Description);
                break;
            }
            case 1: {
                this.setErrorMessage(null);
                this.setMessage(string, 1);
                break;
            }
            case 2: {
                this.setErrorMessage(null);
                this.setMessage(string, 2);
                break;
            }
            default: {
                this.setErrorMessage(string);
                this.setMessage(null);
            }
        }
    }
}

