/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.informix.deploy.ui.wizard.bundle;

import com.ibm.informix.bundle.InstallType;
import com.ibm.informix.bundle.message.BundleMessages;
import com.ibm.informix.bundle.ui.BundleTree;
import com.ibm.informix.bundle.ui.BundleTreeListener;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;

public class InstallTypeCombo
extends Combo
implements BundleTreeListener,
SelectionListener {
    private final BundleTree bundleTree;
    private final Map<String, InstallType> installTypes;
    private int customIndex = -1;

    public InstallTypeCombo(BundleTree bundleTree, Composite composite, int n) {
        super(composite, n);
        this.bundleTree = bundleTree;
        this.installTypes = new HashMap<String, InstallType>();
        this.addSelectionListener(this);
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        int n = this.getSelectionIndex();
        InstallType installType = this.installTypes.get(this.getItem(n));
        if (installType == null) {
            this.bundleTree.checkAll();
        } else if (n != this.customIndex) {
            this.bundleTree.checkAll(installType.getBundleMembers(), true);
        }
        this.select(n);
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        this.widgetSelected(selectionEvent);
    }

    public void itemSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.detail == 32) {
            this.select(this.customIndex);
        }
    }

    protected void checkSubclass() {
    }

    public void add(InstallType installType) {
        this.add(installType, this.getItemCount());
    }

    public void add(InstallType installType, int n) {
        this.add(installType.getName(), n);
        this.installTypes.put(installType.getName(), installType);
    }

    public void addFull() {
        this.addFull(this.getItemCount());
    }

    public void addFull(int n) {
        String string = BundleMessages.getName((String)"INS-FULL");
        this.add(string, n);
        this.installTypes.put(string, null);
    }

    public void addCustom() {
        this.addCustom(this.getItemCount());
    }

    public void addCustom(int n) {
        if (this.customIndex < 0) {
            this.add(new InstallType(BundleMessages.getName((String)"INS-CUSTOM")), n);
            this.customIndex = n;
            this.bundleTree.addListener((BundleTreeListener)this);
        }
    }
}

