/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.informix.deploy.ui.wizard.connect;

import com.ibm.arcs.database.DatabaseProtocol;
import com.ibm.arcs.database.connection.ConnectionParameters;
import com.ibm.arcs.host.ui.widgets.HostNameLabel;
import com.ibm.arcs.host.ui.widgets.HostNameText;
import com.ibm.arcs.host.ui.widgets.HostPortLabel;
import com.ibm.arcs.host.ui.widgets.HostPortText;
import com.ibm.arcs.status.listener.IStatusListener;
import com.ibm.arcs.status.publish.IStatusPublisher;
import com.ibm.arcs.status.ui.group.GroupStatusPublishingComposite;
import com.ibm.arcs.ui.widgets.PasswordLabel;
import com.ibm.arcs.ui.widgets.PasswordText;
import com.ibm.arcs.ui.widgets.UsernameLabel;
import com.ibm.arcs.ui.widgets.UsernameText;
import com.ibm.informix.deploy.Utility;
import com.ibm.informix.deploy.ui.Messages;
import com.ibm.informix.protocol.drda.DrdaProtocol;
import com.ibm.informix.ui.connection.InformixProtocolCombo;
import com.ibm.informix.ui.connection.InformixProtocolLabel;
import com.ibm.informix.ui.connection.InstanceNameLabel;
import com.ibm.informix.ui.connection.InstanceNameText;
import java.util.HashSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ConnectionParametersComposite
extends GroupStatusPublishingComposite {
    private final InstanceNameText instanceNameText;
    private final HostNameText hostNameText;
    private final HostPortText hostPortText;
    private final InformixProtocolCombo dbConnectionProtocolCombo;
    private final Button credentialsButton;
    private final UsernameText usernameText;
    private final PasswordText passwordText;
    private final HashSet<Control> credentialSet;
    private static final int USERNAMEPRIORITY = 4;
    private static final int PASSWORDPRIORITY = 5;

    public ConnectionParametersComposite(Composite composite, int n) {
        super(composite, n);
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.horizontalSpacing = 10;
        gridLayout.verticalSpacing = 10;
        this.setLayout((Layout)gridLayout);
        this.credentialSet = new HashSet();
        Label label = new Label((Composite)this, 64);
        label.setText(Messages.ConnectionParameters_Instruction);
        label.setLayoutData((Object)new GridData(4, 128, true, false, 3, 1));
        new InstanceNameLabel((Composite)this, 0);
        this.instanceNameText = new InstanceNameText((Composite)this, 2048, 0);
        this.instanceNameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        new HostNameLabel((Composite)this, 0);
        this.hostNameText = new HostNameText((Composite)this, 2048, 1);
        this.hostNameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        new HostPortLabel((Composite)this, 0);
        this.hostPortText = new HostPortText((Composite)this, 2048, 2);
        this.hostPortText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        new InformixProtocolLabel((Composite)this, 0);
        this.dbConnectionProtocolCombo = this.getProtocolCombo(this);
        this.credentialsButton = ConnectionParametersComposite.getCredentialsButton(this);
        UsernameLabel usernameLabel = new UsernameLabel((Composite)this, 0);
        this.usernameText = new UsernameText((Composite)this, 2048, 4);
        this.usernameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        PasswordLabel passwordLabel = new PasswordLabel((Composite)this, 0);
        this.passwordText = new PasswordText((Composite)this, 2048, 5);
        this.passwordText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.credentialSet.add((Control)usernameLabel);
        this.credentialSet.add((Control)this.usernameText);
        this.credentialSet.add((Control)passwordLabel);
        this.credentialSet.add((Control)this.passwordText);
        this.addStatusPublisher((IStatusPublisher)this.instanceNameText);
        this.addStatusPublisher((IStatusPublisher)this.hostNameText);
        this.addStatusPublisher((IStatusPublisher)this.hostPortText);
        this.dbConnectionProtocolCombo.setSelected(com.ibm.informix.deploy.ui.Utility.DEFAULTDBPROTOCOL);
        this.setCredentialsEnabled(this.credentialsButton.getSelection());
    }

    public ConnectionParameters getConnectionParameters() throws Exception {
        if (this.instanceNameText.isValid() && this.hostNameText.isValid() && this.hostPortText.isValid()) {
            if (this.credentialsButton.getSelection()) {
                if (this.usernameText.isValid() && this.passwordText.isValid()) {
                    return Utility.getConnectionParameters((String)this.instanceNameText.getText(), (String)this.hostNameText.getText(), (String)this.hostPortText.getText(), (DatabaseProtocol)this.dbConnectionProtocolCombo.getProtocol(), (String)this.usernameText.getText(), (String)this.passwordText.getText());
                }
            } else {
                return Utility.getConnectionParameters((String)this.instanceNameText.getText(), (String)this.hostNameText.getText(), (String)this.hostPortText.getText(), (DatabaseProtocol)this.dbConnectionProtocolCombo.getProtocol());
            }
        }
        throw new RuntimeException(Messages.ConnectionParameters_ErrorInvalidParameters);
    }

    private InformixProtocolCombo getProtocolCombo(ConnectionParametersComposite connectionParametersComposite) {
        final InformixProtocolCombo informixProtocolCombo = new InformixProtocolCombo((Composite)connectionParametersComposite, 2048, 3);
        informixProtocolCombo.addStatusListener(new IStatusListener(){

            public void handleStatusUpdate(IStatus iStatus) {
                if (informixProtocolCombo.getProtocol() instanceof DrdaProtocol) {
                    ConnectionParametersComposite.this.credentialsButton.setSelection(true);
                    ConnectionParametersComposite.this.credentialsButton.setEnabled(false);
                } else {
                    ConnectionParametersComposite.this.credentialsButton.setEnabled(true);
                }
                ConnectionParametersComposite.this.setCredentialsEnabled(ConnectionParametersComposite.this.credentialsButton.getSelection());
            }
        });
        return informixProtocolCombo;
    }

    private static Button getCredentialsButton(ConnectionParametersComposite connectionParametersComposite) {
        final Button button = new Button((Composite)connectionParametersComposite, 32);
        button.setText("Specify username and password");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ConnectionParametersComposite.this.setCredentialsEnabled(button.getSelection());
            }
        });
        return button;
    }

    public void setCredentialsEnabled(boolean bl) {
        for (Control control : this.credentialSet) {
            control.setEnabled(bl);
            control.setVisible(bl);
        }
        if (bl) {
            this.addStatusPublisher((IStatusPublisher)this.usernameText);
            this.addStatusPublisher((IStatusPublisher)this.passwordText);
        } else {
            this.removeStatusPublisher((IStatusPublisher)this.usernameText);
            this.removeStatusPublisher((IStatusPublisher)this.passwordText);
        }
        for (Control control : this.getStatusListeners()) {
            control.handleStatusUpdate(Status.OK_STATUS);
        }
    }

    public IStatus getStatus() {
        IStatus iStatus = super.getStatus();
        if (this.credentialsButton.getSelection() && iStatus.getSeverity() != 4) {
            if (this.usernameText.getText().isEmpty()) {
                iStatus = new Status(4, "com.ibm.arcs.ui", 4, "Username must be specified", null);
            } else if (this.passwordText.getText().isEmpty()) {
                iStatus = new Status(4, "com.ibm.arcs.ui", 5, "Password must be specified", null);
            }
        }
        return iStatus;
    }
}

