/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.informix.deploy.ui.wizard.connect;

import com.ibm.arcs.status.listener.IStatusListener;
import com.ibm.informix.deploy.ui.Messages;
import com.ibm.informix.deploy.ui.wizard.DeploymentWizard;
import com.ibm.informix.deploy.ui.wizard.DeploymentWizardPage;
import com.ibm.informix.deploy.ui.wizard.connect.ConnectionParametersComposite;
import java.sql.SQLException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.MessageBox;

public class ConnectionParametersWizardPage
extends DeploymentWizardPage
implements IStatusListener {
    ConnectionParametersComposite cpc;

    public ConnectionParametersWizardPage() {
        super("ConnectionParameters", Messages.ConnectionParameters_Title, null);
        this.setDescription(Messages.ConnectionParameters_Description);
    }

    @Override
    public void createContent(Composite composite) {
        this.cpc = new ConnectionParametersComposite(composite, 0);
        this.cpc.addStatusListener(this);
        this.applyToStatusLine(this.cpc.getStatus());
    }

    @Override
    protected void createHeader(Composite composite) {
    }

    public IWizardPage getNextPage() {
        try {
            this.getController().setConnection(this.cpc.getConnectionParameters());
            return ((DeploymentWizard)this.getWizard()).packageLocationPage;
        }
        catch (SQLException sQLException) {
            MessageBox messageBox = new MessageBox(this.getShell(), 32);
            messageBox.setMessage(String.valueOf(Messages.ConnectionParameters_ErrorCannotConnectWithInfo) + Messages.NEW_LINE + sQLException.getMessage());
            messageBox.open();
        }
        catch (Exception exception) {
            MessageBox messageBox = new MessageBox(this.getShell(), 32);
            messageBox.setMessage(String.valueOf(Messages.ConnectionParameters_ErrorCannotConnectToInstance) + Messages.NEW_LINE + exception.getMessage());
            messageBox.open();
        }
        return null;
    }

    public boolean canFlipToNextPage() {
        return this.cpc.getStatus().getSeverity() == 0;
    }

    public boolean isPageComplete() {
        return false;
    }

    public void handleStatusUpdate(IStatus iStatus) {
        IStatus iStatus2 = this.cpc.getStatus();
        if (iStatus2 != null) {
            this.applyToStatusLine(iStatus2);
        } else {
            this.setErrorMessage(null);
            this.setMessage(null);
        }
        this.getWizard().getContainer().updateButtons();
    }

    private void applyToStatusLine(IStatus iStatus) {
        String string = iStatus.getMessage();
        if (string.length() == 0) {
            string = null;
        }
        switch (iStatus.getSeverity()) {
            case 0: {
                this.setErrorMessage(null);
                this.setMessage(string);
                break;
            }
            case 1: {
                this.setErrorMessage(null);
                this.setMessage(string, 1);
                break;
            }
            case 2: {
                this.setErrorMessage(null);
                this.setMessage(string, 2);
                break;
            }
            default: {
                this.setErrorMessage(string);
                this.setMessage(null);
            }
        }
    }
}

