/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.informix.deploy.ui.wizard.location;

import com.ibm.arcs.status.publish.IStatusPublisher;
import com.ibm.arcs.status.ui.group.GroupStatusPublishingComposite;
import com.ibm.informix.deploy.DeploymentController;
import com.ibm.informix.deploy.archive.Format;
import com.ibm.informix.deploy.ui.Messages;
import com.ibm.informix.deploy.ui.wizard.location.SnapshotLocationText;
import java.util.ArrayList;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class SnapshotLocationComposite
extends GroupStatusPublishingComposite {
    final SnapshotLocationText snapshotLocationText;
    final Button browseButton;
    private final DeploymentController controller;
    private static final String SPACE = "  ";

    public SnapshotLocationComposite(Composite composite, int n, DeploymentController deploymentController) {
        super(composite, n);
        this.controller = deploymentController;
        this.setLayout((Layout)new GridLayout(3, false));
        new Label((Composite)this, 0).setText(Messages.SnapshotLocation_Location);
        this.snapshotLocationText = new SnapshotLocationText((Composite)this, 2048, 0);
        this.snapshotLocationText.setLayoutData(new GridData(4, 0x1000000, true, false, 1, 1));
        this.browseButton = new Button((Composite)this, 0);
        this.browseButton.setText(SPACE + Messages.SnapshotLocation_Browse + SPACE);
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SnapshotLocationComposite.this.showFileDialog();
            }
        });
        this.addStatusPublisher((IStatusPublisher)this.snapshotLocationText);
    }

    public String getValue() {
        return this.snapshotLocationText.getText();
    }

    public void init() {
        this.snapshotLocationText.setText(this.controller.getConfiguration().getSnapshotFilename());
    }

    private void showFileDialog() {
        FileDialog fileDialog = new FileDialog(this.getShell(), 8192);
        fileDialog.setText(Messages.SnapshotLocation_SaveAsTitle);
        fileDialog.setFilterExtensions(this.getFilterExtensions());
        fileDialog.setFilterNames(this.getFilterNames());
        fileDialog.setOverwrite(true);
        fileDialog.setFilterIndex(1);
        String string = fileDialog.open();
        if (string != null) {
            Format format = Format.getFormatForFile((String)string);
            if (format == null) {
                format = Format.values()[fileDialog.getFilterIndex()];
                string = String.valueOf(string) + format.getExtension();
            }
            this.snapshotLocationText.setText(string);
            this.controller.getConfiguration().setSnapshotFilename(string);
            this.controller.getConfiguration().setArchiveFormat(format);
        }
    }

    private String[] getFilterExtensions() {
        ArrayList<String> arrayList = new ArrayList<String>(Format.values().length);
        Format[] formatArray = Format.values();
        int n = formatArray.length;
        int n2 = 0;
        while (n2 < n) {
            Format format = formatArray[n2];
            arrayList.add("*" + format.getExtension());
            ++n2;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private String[] getFilterNames() {
        ArrayList<String> arrayList = new ArrayList<String>(Format.values().length);
        Format[] formatArray = Format.values();
        int n = formatArray.length;
        int n2 = 0;
        while (n2 < n) {
            Format format = formatArray[n2];
            arrayList.add(String.valueOf(format.name()) + " (*" + format.getExtension() + ")");
            ++n2;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }
}

