/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.informix.deploy.ui.wizard.progress;

import com.ibm.informix.deploy.IProgressListener;
import com.ibm.informix.deploy.ProgressPublisher;
import com.ibm.informix.deploy.job.DeploymentJob;
import com.ibm.informix.deploy.ui.Messages;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;

public class ProgressComposite
extends Composite
implements IProgressListener {
    private static final int PERCENTFACTOR = 10;
    private final ProgressBar progressBar;
    private final CLabel messageLabel;
    private double percent;

    public ProgressComposite(DeploymentJob deploymentJob, Composite composite, int n) {
        super(composite, n);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.verticalSpacing = 0;
        this.setLayout((Layout)gridLayout);
        Label label = new Label((Composite)this, 16448);
        label.setText(deploymentJob.getName());
        label.setLayoutData((Object)new GridData(4, 1, true, false, 1, 1));
        if (deploymentJob instanceof ProgressPublisher) {
            this.progressBar = new ProgressBar((Composite)this, 65536);
            this.progressBar.setMinimum(0);
            this.progressBar.setMaximum(1000);
            ((ProgressPublisher)deploymentJob).registerListener((IProgressListener)this);
        } else {
            this.progressBar = new ProgressBar((Composite)this, 2);
        }
        this.progressBar.setLayoutData((Object)new GridData(4, 1, true, false, 1, 1));
        this.progressBar.setState(4);
        this.messageLabel = new CLabel((Composite)this, 16384);
        this.messageLabel.setText("(Waiting)");
        this.messageLabel.setLayoutData((Object)new GridData(4, 1, true, false, 1, 1));
    }

    public void setMessage(final String string) {
        this.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                ProgressComposite.this.messageLabel.setText(string);
            }
        });
    }

    public void setPercent(final double d) {
        if (this.percent != d) {
            this.percent = d;
            this.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ProgressComposite.this.progressBar.setSelection((int)(d * 10.0));
                }
            });
        }
    }

    public void setState(final int n) {
        this.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                ProgressComposite.this.progressBar.setState(n);
            }
        });
    }

    public void fireStart() {
        this.setState(0);
        this.setPercent(0.0);
    }

    public void fireUpdate(double d) {
        this.setPercent(d);
    }

    public void fireUpdate(String string) {
        this.setMessage(string);
    }

    public void fireComplete() {
        this.setPercent(100.0);
        this.setMessage("(Finished)");
    }

    public void fireError(Throwable throwable) {
        this.setState(1);
        this.fireUpdate(String.valueOf(Messages.Progress_error) + ": " + throwable.getMessage());
    }
}

