/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.informix.deploy.ui.wizard.progress;

import com.ibm.informix.deploy.IProgressListener;
import com.ibm.informix.deploy.ProgressPublisher;
import com.ibm.informix.deploy.job.DeploymentJob;
import com.ibm.informix.deploy.ui.Messages;
import com.ibm.informix.deploy.ui.wizard.DeploymentWizard;
import com.ibm.informix.deploy.ui.wizard.DeploymentWizardPage;
import com.ibm.informix.deploy.ui.wizard.progress.ProgressComposite;
import java.util.Iterator;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ProgressWizardPage
extends DeploymentWizardPage
implements IProgressListener {
    private Composite contentComposite;
    private Iterator<DeploymentJob> jobsIterator;

    public ProgressWizardPage() {
        super("Packaging", String.valueOf(Messages.Progress_Title) + "...", null);
        this.setDescription(Messages.Progress_Description);
    }

    @Override
    protected void createContent(Composite composite) {
        ScrolledComposite scrolledComposite = new ScrolledComposite(composite, 768);
        scrolledComposite.setLayout((Layout)new GridLayout(1, false));
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        this.contentComposite = new Composite((Composite)scrolledComposite, 0);
        this.contentComposite.setLayoutData((Object)new GridData(4, 1, true, false, 1, 1));
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.verticalSpacing = 15;
        this.contentComposite.setLayout((Layout)gridLayout);
        scrolledComposite.setContent((Control)this.contentComposite);
        this.setHeaderExpanded(true);
    }

    @Override
    public void onEnterPage() {
        super.onEnterPage();
        this.jobsIterator = this.getController().getJobs().iterator();
        for (DeploymentJob deploymentJob : this.getController().getJobs()) {
            ProgressComposite progressComposite = new ProgressComposite(deploymentJob, this.contentComposite, 0);
            progressComposite.setLayoutData(new GridData(4, 1, true, false, 1, 1));
            Label label = new Label(this.contentComposite, 258);
            label.setLayoutData((Object)new GridData(4, 1, true, false, 1, 1));
            if (!(deploymentJob instanceof ProgressPublisher)) continue;
            ((ProgressPublisher)deploymentJob).registerListener((IProgressListener)this);
        }
        this.contentComposite.layout();
        this.nextJob();
    }

    private void nextJob() {
        if (this.jobsIterator.hasNext()) {
            new Thread((Runnable)this.jobsIterator.next()).start();
        } else {
            this.finish();
        }
    }

    private void finish() {
        this.getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                ((DeploymentWizard)ProgressWizardPage.this.getWizard()).summaryPage.complete();
            }
        });
    }

    public boolean canFlipToNextPage() {
        return false;
    }

    public IWizardPage getPreviousPage() {
        return null;
    }

    public void fireStart() {
    }

    public void fireUpdate(double d) {
    }

    public void fireUpdate(String string) {
    }

    public void fireComplete() {
        this.nextJob();
    }

    public void fireError(final Throwable throwable) {
        this.fireUpdate(String.valueOf(Messages.Progress_error) + ": " + throwable.getMessage());
        this.getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                ((DeploymentWizard)ProgressWizardPage.this.getWizard()).summaryPage.error(throwable.getMessage());
            }
        });
    }
}

