/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.informix.deploy.ui.wizard.spaces;

import com.ibm.arcs.basic.unit.ByteUnit;
import com.ibm.arcs.basic.unit.ByteValue;
import com.ibm.informix.configuration.space.InformixDataSpace;
import com.ibm.informix.deploy.ui.Messages;
import com.ibm.informix.ui.configuration.space.DataSpacesTree;
import com.ibm.informix.ui.configuration.space.SizeColumn;
import java.text.NumberFormat;
import java.util.Collection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TreeItem;

public class SpacesComposite
extends Composite {
    private final DataSpacesTree dataSpacesTree;
    public final Button dataSpacesButton;
    private final Label totalHeader;
    private final Label totalLabel;
    private ByteValue total;

    public SpacesComposite(Composite composite, int n) {
        super(composite, n);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.verticalSpacing = 10;
        this.setLayout((Layout)gridLayout);
        this.dataSpacesButton = this.getSpacesButton(this);
        this.dataSpacesButton.setSelection(false);
        this.dataSpacesTree = new DataSpacesTree((Composite)this, 67584, 0, true);
        this.dataSpacesTree.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        new SizeColumn(this.dataSpacesTree);
        Composite composite2 = new Composite((Composite)this, 0);
        composite2.setLayoutData((Object)new GridData(0x1000008, 4, true, false, 1, 1));
        RowLayout rowLayout = new RowLayout(256);
        rowLayout.spacing = 10;
        composite2.setLayout((Layout)rowLayout);
        this.totalHeader = new Label(composite2, 0);
        this.totalHeader.setText("Total Size: ");
        this.totalLabel = new Label(composite2, 0);
        this.setSpacesEnabled(this.dataSpacesButton.getSelection());
    }

    public void populate(Collection<InformixDataSpace> collection) {
        this.setSpacesEnabled(false);
        try {
            this.dataSpacesTree.unload();
            this.dataSpacesTree.populate(collection);
            this.updateTotal();
            this.setSpacesEnabled(this.dataSpacesButton.getSelection());
        }
        catch (Exception exception) {
            new Label((Composite)this, 0).setText(Messages.Data_ErrorBundleRetrieve);
        }
    }

    private Button getSpacesButton(Composite composite) {
        Button button = new Button(composite, 32);
        button.setText(Messages.Data_Include);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SpacesComposite.this.setSpacesEnabled(SpacesComposite.this.dataSpacesButton.getSelection());
            }
        });
        return button;
    }

    private void setSpacesEnabled(boolean bl) {
        this.dataSpacesTree.setEnabled(bl);
        this.totalHeader.setEnabled(bl);
        this.totalLabel.setEnabled(bl);
    }

    public DataSpacesTree getDataSpacesTree() {
        return this.dataSpacesTree;
    }

    public boolean isDataSpacesSelected() {
        return this.dataSpacesButton.getSelection();
    }

    private void updateTotal() {
        this.total = SizeColumn.ZERO;
        TreeItem[] treeItemArray = this.dataSpacesTree.getTree().getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem = treeItemArray[n2];
            this.total = this.total.add((ByteValue)treeItem.getData("SIZE_INDEX"));
            ++n2;
        }
        this.totalLabel.setText(SizeColumn.getSize((ByteValue)this.total, (NumberFormat)SizeColumn.SPACE_FORMAT, (ByteUnit)SizeColumn.SPACE_BYTEUNIT));
        this.layout();
    }
}

